% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{supported_models}
\alias{supported_models}
\title{Listing of Supported Models}
\format{
A data frame with one row per supported model
\describe{
\item{model}{Model}
\item{notes}{Notes}
}
}
\usage{
supported_models
}
\description{
Listing of Supported Models
}
\section{Supported models}{
\tabular{ll}{
   model \tab notes \cr
   \code{betareg::betareg()} \tab Use \code{tidy_parameters()} as \code{tidy_fun} with \code{component} argument to control with coefficients to return. \code{broom::tidy()} does not support the \code{exponentiate} argument for betareg models, use \code{tidy_parameters()} instead. \cr
   \code{biglm::bigglm()} \tab  \cr
   \code{biglmm::bigglm()} \tab  \cr
   \code{brms::brm()} \tab \code{broom.mixed} package required \cr
   \code{cmprsk::crr()} \tab Limited support. It is recommended to use \code{tidycmprsk::crr()} instead. \cr
   \code{fixest::feglm()} \tab May fail with R <= 4.0. \cr
   \code{fixest::femlm()} \tab May fail with R <= 4.0. \cr
   \code{fixest::feNmlm()} \tab May fail with R <= 4.0. \cr
   \code{fixest::feols()} \tab May fail with R <= 4.0. \cr
   \code{gam::gam()} \tab  \cr
   \code{geepack::geeglm()} \tab  \cr
   \code{glmmTMB::glmmTMB()} \tab \code{broom.mixed} package required \cr
   \code{lavaan::lavaan()} \tab Limited support for categorical variables \cr
   \code{lfe::felm()} \tab  \cr
   \code{lme4::glmer.nb()} \tab \code{broom.mixed} package required \cr
   \code{lme4::glmer()} \tab \code{broom.mixed} package required \cr
   \code{lme4::lmer()} \tab \code{broom.mixed} package required \cr
   \code{logitr::logitr()} \tab Requires logitr >= 0.8.0 \cr
   \code{MASS::glm.nb()} \tab  \cr
   \code{MASS::polr()} \tab  \cr
   \code{mgcv::gam()} \tab Use default tidier \code{broom::tidy()} for smooth terms only, or \code{gtsummary::tidy_gam()} to include parametric terms \cr
   \code{mice::mira} \tab Limited support. If \code{mod} is a \code{mira} object, use \code{tidy_fun = function(x, ...) {mice::pool(x) \%>\% mice::tidy(...)}} \cr
   \code{mmrm::mmrm()} \tab  \cr
   \code{multgee::nomLORgee()} \tab Experimental support. Use \code{tidy_multgee()} as \code{tidy_fun}. \cr
   \code{multgee::ordLORgee()} \tab Experimental support. Use \code{tidy_multgee()} as \code{tidy_fun}. \cr
   \code{nnet::multinom()} \tab  \cr
   \code{ordinal::clm()} \tab Limited support for models with nominal predictors. \cr
   \code{ordinal::clmm()} \tab Limited support for models with nominal predictors. \cr
   \code{parsnip::model_fit} \tab Supported as long as the type of model and the engine is supported. \cr
   \code{plm::plm()} \tab  \cr
   \code{pscl::hurdle()} \tab Use \code{tidy_zeroinfl()} as \code{tidy_fun}. \cr
   \code{pscl::zeroinfl()} \tab Use \code{tidy_zeroinfl()} as \code{tidy_fun}. \cr
   \code{rstanarm::stan_glm()} \tab \code{broom.mixed} package required \cr
   \code{stats::aov()} \tab Reference rows are not relevant for such models. \cr
   \code{stats::glm()} \tab  \cr
   \code{stats::lm()} \tab  \cr
   \code{stats::nls()} \tab Limited support \cr
   \code{survey::svycoxph()} \tab  \cr
   \code{survey::svyglm()} \tab  \cr
   \code{survey::svyolr()} \tab  \cr
   \code{survival::cch()} \tab `Experimental support. \cr
   \code{survival::clogit()} \tab  \cr
   \code{survival::coxph()} \tab  \cr
   \code{survival::survreg()} \tab  \cr
   \code{tidycmprsk::crr()} \tab  \cr
   \code{VGAM::vglm()} \tab Limited support. It is recommended to use \code{tidy_parameters()} as \code{tidy_fun}. \cr
}
}

\keyword{datasets}
