% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marginal_tidiers.R
\name{tidy_all_effects}
\alias{tidy_all_effects}
\title{Marginal Predictions at the mean with \code{effects::allEffects()}}
\usage{
tidy_all_effects(x, conf.int = TRUE, conf.level = 0.95, ...)
}
\arguments{
\item{x}{(a model object, e.g. \code{glm})\cr
A model to be tidied.}

\item{conf.int}{(\code{logical})\cr
Whether or not to include a confidence interval in the tidied output.}

\item{conf.level}{(\code{numeric})\cr
The confidence level to use for the confidence interval (between \code{0} ans \code{1}).}

\item{...}{Additional parameters passed to \code{effects::allEffects()}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Use \code{effects::allEffects()} to estimate marginal predictions and
return a tibble tidied in a way that it could be used by \code{broom.helpers}
functions.
See \code{vignette("functions-supported-by-effects", package = "effects")} for
a list of supported models.
}
\details{
By default, \code{effects::allEffects()} estimate marginal predictions at the mean
at the observed means for continuous variables and weighting modalities
of categorical variables according to their observed distribution in the
original dataset. Marginal predictions are therefore computed at
a sort of averaged situation / typical values for the other variables fixed
in the model.

For more information, see \code{vignette("marginal_tidiers", "broom.helpers")}.
}
\note{
If the model contains interactions, \code{effects::allEffects()} will return
marginal predictions for the different levels of the interactions.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
df <- Titanic |>
  dplyr::as_tibble() |>
  tidyr::uncount(n) |>
  dplyr::mutate(Survived = factor(Survived, c("No", "Yes")))
mod <- glm(
  Survived ~ Class + Age + Sex,
  data = df, family = binomial
)
tidy_all_effects(mod)
tidy_plus_plus(mod, tidy_fun = tidy_all_effects)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{effects::allEffects()}

Other marginal_tieders: 
\code{\link{tidy_avg_comparisons}()},
\code{\link{tidy_avg_slopes}()},
\code{\link{tidy_ggpredict}()},
\code{\link{tidy_marginal_contrasts}()},
\code{\link{tidy_marginal_means}()},
\code{\link{tidy_marginal_predictions}()},
\code{\link{tidy_margins}()}
}
\concept{marginal_tieders}
