% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lme4_tidiers.R
\name{lme4_tidiers}
\alias{lme4_tidiers}
\alias{tidy.merMod}
\alias{augment.merMod}
\alias{glance.merMod}
\title{Tidying methods for mixed effects models}
\usage{
\method{tidy}{merMod}(x, effects = c("ran_pars", "fixed"), scales = NULL,
  ran_prefix = NULL, conf.int = FALSE, conf.level = 0.95,
  conf.method = "Wald", ...)

\method{augment}{merMod}(x, data = stats::model.frame(x), newdata, ...)

\method{glance}{merMod}(x, ...)
}
\arguments{
\item{x}{An object of class \code{merMod}, such as those from \code{lmer},
\code{glmer}, or \code{nlmer}}

\item{effects}{A character vector including one or more of "fixed" (fixed-effect parameters), "ran_pars" (variances and covariances or standard deviations and correlations of random effect terms) or "ran_modes" (conditional modes/BLUPs/latent variable estimates)}

\item{scales}{scales on which to report the variables: for random effects, the choices are \sQuote{"sdcor"} (standard deviations and correlations: the default if \code{scales} is \code{NULL}) or \sQuote{"vcov"} (variances and covariances). \code{NA} means no transformation, appropriate e.g. for fixed effects; inverse-link transformations (exponentiation
or logistic) are not yet implemented, but may be in the future.}

\item{ran_prefix}{a length-2 character vector specifying the strings to use as prefixes for self- (variance/standard deviation) and cross- (covariance/correlation) random effects terms}

\item{conf.int}{whether to include a confidence interval}

\item{conf.level}{confidence level for CI}

\item{conf.method}{method for computing confidence intervals (see \code{lme4::confint.merMod})}

\item{...}{extra arguments (not used)}

\item{data}{original data this was fitted on; if not given this will
attempt to be reconstructed}

\item{newdata}{new data to be used for prediction; optional}
}
\value{
All tidying methods return a \code{data.frame} without rownames.
The structure depends on the method chosen.

\code{tidy} returns one row for each estimated effect, either
with groups depending on the \code{effects} parameter.
It contains the columns
  \item{group}{the group within which the random effect is being estimated: \code{"fixed"} for fixed effects}
  \item{level}{level within group (\code{NA} except for modes)}
  \item{term}{term being estimated}
  \item{estimate}{estimated coefficient}
  \item{std.error}{standard error}
  \item{statistic}{t- or Z-statistic (\code{NA} for modes)}
  \item{p.value}{P-value computed from t-statistic (may be missing/NA)}

\code{augment} returns one row for each original observation,
with columns (each prepended by a .) added. Included are the columns
  \item{.fitted}{predicted values}
  \item{.resid}{residuals}
  \item{.fixed}{predicted values with no random effects}

Also added for "merMod" objects, but not for "mer" objects,
are values from the response object within the model (of type
\code{lmResp}, \code{glmResp}, \code{nlsResp}, etc). These include \code{".mu",
".offset", ".sqrtXwt", ".sqrtrwt", ".eta"}.

\code{glance} returns one row with the columns
  \item{sigma}{the square root of the estimated residual variance}
  \item{logLik}{the data's log-likelihood under the model}
  \item{AIC}{the Akaike Information Criterion}
  \item{BIC}{the Bayesian Information Criterion}
  \item{deviance}{deviance}
}
\description{
These methods tidy the coefficients of mixed effects models, particularly
responses of the \code{merMod} class
}
\details{
When the modeling was performed with \code{na.action = "na.omit"}
(as is the typical default), rows with NA in the initial data are omitted
entirely from the augmented data frame. When the modeling was performed
with \code{na.action = "na.exclude"}, one should provide the original data
as a second argument, at which point the augmented data will contain those
rows (typically with NAs in place of the new columns). If the original data
is not provided to \code{augment} and \code{na.action = "na.exclude"}, a
warning is raised and the incomplete rows are dropped.
}
\examples{

\dontrun{
if (require("lme4")) {
    # example regressions are from lme4 documentation
    lmm1 <- lmer(Reaction ~ Days + (Days | Subject), sleepstudy)
    tidy(lmm1)
    tidy(lmm1, effects = "fixed")
    tidy(lmm1, effects = "fixed", conf.int=TRUE)
    tidy(lmm1, effects = "fixed", conf.int=TRUE, conf.method="profile")
    tidy(lmm1, effects = "ran_modes", conf.int=TRUE)
    head(augment(lmm1, sleepstudy))
    glance(lmm1)

    glmm1 <- glmer(cbind(incidence, size - incidence) ~ period + (1 | herd),
                  data = cbpp, family = binomial)
    tidy(glmm1)
    tidy(glmm1, effects = "fixed")
    head(augment(glmm1, cbpp))
    glance(glmm1)

    startvec <- c(Asym = 200, xmid = 725, scal = 350)
    nm1 <- nlmer(circumference ~ SSlogis(age, Asym, xmid, scal) ~ Asym|Tree,
                  Orange, start = startvec)
    tidy(nm1)
    tidy(nm1, effects = "fixed")
    head(augment(nm1, Orange))
    glance(nm1)
}
}
}
\seealso{
\link{na.action}
}
