% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantreg-nlrq-tidiers.R
\name{augment.nlrq}
\alias{augment.nlrq}
\title{Tidy a(n) nlrq object}
\usage{
\method{augment}{nlrq}(x, ...)
}
\arguments{
\item{x}{A \code{nlrq} object returned from \code{\link[quantreg:nlrq]{quantreg::nlrq()}}.}

\item{...}{Arguments passed on to \code{augment.nls}
\describe{
  \item{data}{A \code{\link[=data.frame]{data.frame()}} or \code{\link[tibble:tibble]{tibble::tibble()}} containing the original
data that was used to produce the object \code{x}. Defaults to
\code{stats::model.frame(x)} so that \code{augment(my_fit)} returns the augmented
original data. \strong{Do not} pass new data to the \code{data} argument.
Augment will report information such as influence and cooks distance for
data passed to the \code{data} argument. These measures are only defined for
the original training data.}
  \item{newdata}{A \code{\link[=data.frame]{data.frame()}} or \code{\link[tibble:tibble]{tibble::tibble()}} containing all
the original predictors used to create \code{x}. Defaults to \code{NULL}, indicating
that nothing has been passed to \code{newdata}. If \code{newdata} is specified,
the \code{data} argument will be ignored.}
  \item{x}{An \code{nls} object returned from \code{\link[stats:nls]{stats::nls()}}.}
}}
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} containing the data passed to \code{augment},
and \strong{additional} columns:

\item{.fitted}{The predicted response for that observation.}
\item{.resid}{The residual for a particular point. Present only when
data has been passed to \code{augment} via the \code{data} argument.}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies cross models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\seealso{
\code{\link[=augment]{augment()}}, \code{\link[quantreg:nlrq]{quantreg::nlrq()}}

Other quantreg tidiers: \code{\link{augment.rqs}},
  \code{\link{augment.rq}}, \code{\link{glance.nlrq}},
  \code{\link{glance.rq}}, \code{\link{tidy.nlrq}},
  \code{\link{tidy.rqs}}, \code{\link{tidy.rq}}
}
\concept{quantreg tidiers}
