% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mass-rlm-tidiers.R
\name{glance.rlm}
\alias{glance.rlm}
\alias{rlm_tidiers}
\title{Glance at a(n) rlm object}
\usage{
\method{glance}{rlm}(x, ...)
}
\arguments{
\item{x}{An \code{rlm} object returned by \code{\link[MASS:rlm]{MASS::rlm()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\value{
A one-row \link[tibble:tibble]{tibble::tibble} with columns:

\item{sigma}{The square root of the estimated residual variance}
\item{converged}{whether the IWLS converged}
\item{logLik}{the data's log-likelihood under the model}
\item{AIC}{the Akaike Information Criterion}
\item{BIC}{the Bayesian Information Criterion}
\item{deviance}{deviance}
}
\description{
Glance accepts a model object and returns a \code{\link[tibble:tibble]{tibble::tibble()}}
with exactly one row of model summaries. The summaries are typically
goodness of fit measures, p-values for hypothesis tests on residuals,
or model convergence information.

Glance never returns information from the original call to the modelling
function. This includes the name of the modelling function or any
arguments passed to the modelling function.

Glance does not calculate summary measures. Rather, it farms out these
computations to appropriate methods and gathers the results together.
Sometimes a goodness of fit measure will be undefined. In these cases
the measure will be reported as \code{NA}.
}
\details{
For tidiers for models from the \pkg{robust} package see
\code{\link[=tidy.lmRob]{tidy.lmRob()}} and \code{\link[=tidy.glmRob]{tidy.glmRob()}}.
}
\examples{

library(MASS)

r <- rlm(stack.loss ~ ., stackloss)
tidy(r)
augment(r)
glance(r)

}
\seealso{
\code{\link[=glance]{glance()}}, \code{\link[MASS:rlm]{MASS::rlm()}}

Other rlm tidiers: \code{\link{augment.rlm}},
  \code{\link{tidy.rlm}}
}
\concept{rlm tidiers}
