% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats-prcomp-tidiers.R
\name{tidy.prcomp}
\alias{tidy.prcomp}
\alias{prcomp_tidiers}
\title{Tidy a(n) prcomp object}
\usage{
\method{tidy}{prcomp}(x, matrix = "u", ...)
}
\arguments{
\item{x}{A \code{prcomp} object returned by \code{\link[stats:prcomp]{stats::prcomp()}}.}

\item{matrix}{Character specifying which component of the PCA should be
tidied.
\itemize{
\item \code{"u"}, \code{"samples"}, \code{"scores"}, or \code{"x"}: returns information about
the map from the original space into principle components space.
\item \code{"v"}, \code{"rotation"}, \code{"loadings"} or \code{"variables"}: returns information
about the map from principle components space back into the original
space.
\item \code{"d"}, \code{"eigenvalues"} or \code{"pcs"}: returns information about the
eigenvalues.
}}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\value{
A \link[tibble:tibble]{tibble::tibble} with columns depending on the component of
PCA being tidied.

If \code{matrix} is \code{"u"}, \code{"samples"}, \code{"scores"}, or \code{"x"} each row in the
tidied output corresponds to the original data in PCA space. The columns
are:

\item{\code{row}}{ID of the original observation (i.e. rowname from original
data).}
\item{\code{PC}}{Integer indicating a principal component.}
\item{\code{value}}{The score of the observation for that particular principal
component. That is, the location of the observation in PCA space.}

If \code{matrix} is \code{"v"}, \code{"rotation"}, \code{"loadings"} or \code{"variables"}, each
row in the tidied output corresponds to information about the principle
components in the original space. The columns are:

\item{\code{row}}{The variable labels (colnames) of the data set on
which PCA was performed}
\item{\code{PC}}{An integer vector indicating the principal component}
\item{\code{value}}{The value of the eigenvector (axis score) on the
indicated principal component}

If \code{matrix} is \code{"d"}, \code{"eigenvalues"} or \code{"pcs"}, the columns are:

\item{\code{PC}}{An integer vector indicating the principal component}
\item{\code{std.dev}}{Standard deviation explained by this PC}
\item{\code{percent}}{Fraction of variation explained by this component
(a numeric value between 0 and 1).}
\item{\code{cumulative}}{Cumulative fraction of variation explained by
principle components up to this component (a numeric value between 0 and
1).}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies across models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\details{
See https://stats.stackexchange.com/questions/134282/relationship-between-svd-and-pca-how-to-use-svd-to-perform-pca
for information on how to interpret the various tidied matrices. Note
that SVD is only equivalent to PCA on centered data.
}
\examples{

pc <- prcomp(USArrests, scale = TRUE)

# information about rotation
tidy(pc)

# information about samples (states)
tidy(pc, "samples")

# information about PCs
tidy(pc, "pcs")

# state map
library(dplyr)
library(ggplot2)

pc \%>\%
  tidy(matrix = "samples") \%>\%
  mutate(region = tolower(row)) \%>\%
  inner_join(map_data("state"), by = "region") \%>\%
  ggplot(aes(long, lat, group = group, fill = value)) +
  geom_polygon() +
  facet_wrap(~PC) +
  theme_void() +
  ggtitle("Principal components of arrest data")

au <- augment(pc, data = USArrests)
au

ggplot(au, aes(.fittedPC1, .fittedPC2)) +
  geom_point() +
  geom_text(aes(label = .rownames), vjust = 1, hjust = 1)
}
\seealso{
\code{\link[stats:prcomp]{stats::prcomp()}}, \link{svd_tidiers}

Other svd tidiers: 
\code{\link{augment.prcomp}()},
\code{\link{tidy_irlba}()},
\code{\link{tidy_svd}()}
}
\concept{svd tidiers}
