% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantreg-rq-tidiers.R
\name{glance.rq}
\alias{glance.rq}
\title{Glance at a(n) rq object}
\usage{
\method{glance}{rq}(x, ...)
}
\arguments{
\item{x}{An \code{rq} object returned from \code{\link[quantreg:rq]{quantreg::rq()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\description{
Glance accepts a model object and returns a \code{\link[tibble:tibble]{tibble::tibble()}}
with exactly one row of model summaries. The summaries are typically
goodness of fit measures, p-values for hypothesis tests on residuals,
or model convergence information.

Glance never returns information from the original call to the modeling
function. This includes the name of the modeling function or any
arguments passed to the modeling function.

Glance does not calculate summary measures. Rather, it farms out these
computations to appropriate methods and gathers the results together.
Sometimes a goodness of fit measure will be undefined. In these cases
the measure will be reported as \code{NA}.

Glance returns the same number of columns regardless of whether the
model matrix is rank-deficient or not. If so, entries in columns
that no longer have a well-defined value are filled in with an \code{NA}
of the appropriate type.
}
\details{
Only models with a single \code{tau} value may be passed.
For multiple values, please use a \code{\link[purrr:map]{purrr::map()}} workflow instead, e.g.\preformatted{taus \%>\%
  map(function(tau_val) rq(y ~ x, tau = tau_val)) \%>\%
  map_dfr(glance)
}
}
\seealso{
\code{\link[=glance]{glance()}}, \code{\link[quantreg:rq]{quantreg::rq()}}

Other quantreg tidiers: 
\code{\link{augment.nlrq}()},
\code{\link{augment.rqs}()},
\code{\link{augment.rq}()},
\code{\link{glance.nlrq}()},
\code{\link{tidy.nlrq}()},
\code{\link{tidy.rqs}()},
\code{\link{tidy.rq}()}
}
\concept{quantreg tidiers}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with exactly one row and columns:
  \item{AIC}{Akaike's Information Criterion for the model.}
  \item{BIC}{Bayesian Information Criterion for the model.}
  \item{df.residual}{Residual degrees of freedom.}
  \item{logLik}{The log-likelihood of the model. [stats::logLik()] may be a useful reference.}
  \item{tau}{Quantile.}

}
