% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lavaan-tidiers.R
\name{glance.lavaan}
\alias{glance.lavaan}
\title{Glance at a(n) lavaan object}
\usage{
\method{glance}{lavaan}(x, ...)
}
\arguments{
\item{x}{A \code{lavaan} object, such as those returned from \code{\link[lavaan:cfa]{lavaan::cfa()}},
and \code{\link[lavaan:sem]{lavaan::sem()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\value{
A one-row \link[tibble:tibble]{tibble::tibble} with columns:

\item{chisq}{Model chi squared}
\item{npar}{Number of parameters in the model}
\item{rmsea}{Root mean square error of approximation}
\item{rmsea.conf.high}{95 percent upper bound on RMSEA}
\item{srmr}{Standardised root mean residual}
\item{agfi}{Adjusted goodness of fit}
\item{cfi}{Comparative fit index}
\item{tli}{Tucker Lewis index}
\item{AIC}{Akaike information criterion}
\item{BIC}{Bayesian information criterion}
\item{ngroups}{Number of groups in model}
\item{nobs}{Number of observations included}
\item{norig}{Number of observation in the original dataset}
\item{nexcluded}{Number of excluded observations}
\item{converged}{Logical - Did the model converge}
\item{estimator}{Estimator used}
\item{missing_method}{Method for eliminating missing data}

For further recommendations on reporting SEM and CFA models see
Schreiber, J. B. (2017). Update to core reporting practices in
structural equation modeling. Research in Social and Administrative
Pharmacy, 13(3), 634-643. https://doi.org/10.1016/j.sapharm.2016.06.006
}
\description{
Glance accepts a model object and returns a \code{\link[tibble:tibble]{tibble::tibble()}}
with exactly one row of model summaries. The summaries are typically
goodness of fit measures, p-values for hypothesis tests on residuals,
or model convergence information.

Glance never returns information from the original call to the modeling
function. This includes the name of the modeling function or any
arguments passed to the modeling function.

Glance does not calculate summary measures. Rather, it farms out these
computations to appropriate methods and gathers the results together.
Sometimes a goodness of fit measure will be undefined. In these cases
the measure will be reported as \code{NA}.

Glance returns the same number of columns regardless of whether the
model matrix is rank-deficient or not. If so, entries in columns
that no longer have a well-defined value are filled in with an \code{NA}
of the appropriate type.
}
\examples{

\dontrun{
library(lavaan)

cfa.fit <- cfa(
  "F =~ x1 + x2 + x3 + x4 + x5",
  data = HolzingerSwineford1939, group = "school"
)
glance(cfa.fit)
}

}
\seealso{
\code{\link[=glance]{glance()}}, \code{\link[lavaan:cfa]{lavaan::cfa()}}, \code{\link[lavaan:sem]{lavaan::sem()}},
\code{\link[lavaan:fitMeasures]{lavaan::fitmeasures()}}

Other lavaan tidiers: 
\code{\link{tidy.lavaan}()}
}
\concept{lavaan tidiers}
