% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/predictive_posterior.R
\name{Post_x}
\alias{Post_x}
\alias{dpost_x}
\alias{ppost_x}
\alias{qpost_x}
\alias{rpost_x}
\alias{spost_x}
\title{Posterior predictive distribution of the count in the treated group}
\usage{
dpost_x(xnew, Snew, a = 0.5, c = 0.5, d = 0, x, y, S)

ppost_x(q, Snew, a = 0.5, c = 0.5, d = 0, x, y, S)

qpost_x(p, Snew, a = 0.5, c = 0.5, d = 0, x, y, S)

rpost_x(n, Snew, a = 0.5, c = 0.5, d = 0, x, y, S)

spost_x(Snew, a = 0.5, c = 0.5, d = 0, x, y, S, ...)
}
\arguments{
\item{xnew,q}{vector of non-negative \strong{integer} quantiles}

\item{a}{non-negative shape parameter of the Gamma prior distribution on the rate \eqn{\mu}}

\item{c,d}{non-negative shape parameters of the prior distribution on \eqn{\phi}}

\item{x,y}{counts (integer) in the treated group and control group of the observed experiment}

\item{S,Snew}{sample sizes of the treated group in the observed experiment and the
predicted experiment}

\item{p}{vector of probabilities}

\item{n}{number of observations to be simulated}

\item{...}{arguments passed to \code{\link{summary_PGIB}}}
}
\value{
\code{dpost_x} gives the density, \code{ppost_x} the distribution function,
\code{qpost_x} the quantile function, \code{rpost_x} samples from the distribution,
and \code{spost_x} gives a summary of the distribution.
}
\description{
Density, distribution function, quantile function and random
generation for the posterior predictive distribution of the count in the treated group.










}
\details{
The posterior predictive distribution of the count in the treated group is a
\code{\link[=PGIBDist]{Poisson-Gamma-Inverse Beta distribution}}.
}
\note{
\code{Post_x} is a generic name for the functions documented.
}
\examples{
barplot(dpost_x(0:10, 10, 2, 3, 4, 5, 3, 10))
qpost_x(0.5, 10, 2, 3, 4, 5, 3, 10)
ppost_x(4, 10, 2, 3, 4, 5, 3, 10)
}

