% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bruceR_stats_01_basic.R
\name{Describe}
\alias{Describe}
\title{Descriptive statistics (to R Console or MS Word).}
\usage{
Describe(
  data,
  nsmall = 2,
  all.as.numeric = TRUE,
  file = NULL,
  plot = FALSE,
  upper.triangle = FALSE,
  upper.smooth = "none",
  plot.file = NULL,
  plot.width = 8,
  plot.height = 6,
  plot.dpi = 500
)
}
\arguments{
\item{data}{Data frame or numeric vector.}

\item{nsmall}{Number of decimal places of output. Default is \code{2}.}

\item{all.as.numeric}{\code{TRUE} (default) or \code{FALSE}.
Transform all variables into numeric (continuous).}

\item{file}{File name of MS Word (\code{.doc}).}

\item{plot}{\code{TRUE} or \code{FALSE} (default).
Visualize the descriptive statistics using \code{\link[GGally:ggpairs]{GGally::ggpairs()}}.}

\item{upper.triangle}{\code{TRUE} or \code{FALSE} (default).
Add (scatter) plots to upper triangle (time consuming when sample size is large).}

\item{upper.smooth}{\code{"none"} (default), \code{"lm"}, or \code{"loess"}.
Add fitting lines to scatter plots (if any).}

\item{plot.file}{\code{NULL} (default, plot in RStudio) or a file name (\code{"xxx.png"}).}

\item{plot.width}{Width (in "inch") of the saved plot. Default is \code{8}.}

\item{plot.height}{Height (in "inch") of the saved plot. Default is \code{6}.}

\item{plot.dpi}{DPI (dots per inch) of the saved plot. Default is \code{500}.}
}
\value{
Invisibly return a list consisting of
(1) a data frame of descriptive statistics and
(2) a \code{ggplot2} object if users set \code{plot=TRUE}.
}
\description{
Descriptive statistics (to R Console or MS Word).
}
\examples{
\donttest{set.seed(1)
Describe(rnorm(1000000), plot=TRUE)

Describe(airquality)
Describe(airquality, plot=TRUE, upper.triangle=TRUE, upper.smooth="lm")

?psych::bfi
Describe(bfi[c("age", "gender", "education")])

d=as.data.table(psych::bfi)
d[,`:=`(
  gender=as.factor(gender),
  education=as.factor(education),
  E=MEAN(d, "E", 1:5, rev=c(1,2), likert=1:6),
  A=MEAN(d, "A", 1:5, rev=1, likert=1:6),
  C=MEAN(d, "C", 1:5, rev=c(4,5), likert=1:6),
  N=MEAN(d, "N", 1:5, likert=1:6),
  O=MEAN(d, "O", 1:5, rev=c(2,5), likert=1:6)
)]
Describe(d[,.(age, gender, education)], plot=TRUE, all.as.numeric=FALSE)
Describe(d[,.(age, gender, education, E, A, C, N, O)], plot=TRUE)
}
}
\seealso{
\code{\link{Corr}}
}
