% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bruceR-stats_4_regress.R
\name{group_mean_center}
\alias{group_mean_center}
\title{Group-mean centering.}
\usage{
group_mean_center(
  data,
  vars = setdiff(names(data), by),
  by,
  std = FALSE,
  add.suffix = "",
  add.group.mean = "_mean"
)
}
\arguments{
\item{data}{Data object.}

\item{vars}{Variable(s) to be centered.}

\item{by}{Grouping variable.}

\item{std}{Standardized or not. Default is \code{FALSE}.}

\item{add.suffix}{The suffix of the centered variable(s).
Default is \code{""}. You may set it to \code{"_c"}, \code{"_center"}, etc.}

\item{add.group.mean}{The suffix of the variable name(s) of group means.
Default is \code{"_mean"} (see Examples).}
}
\value{
A new data object containing the centered variable(s).
}
\description{
Compute group-mean centered variables.
Usually used for HLM level-1 predictors.
}
\examples{
d = data.table(x=1:9, g=rep(1:3, each=3))

d.c = group_mean_center(d, "x", by="g")
d.c

d.c = group_mean_center(d, "x", by="g", add.suffix="_c")
d.c

}
\seealso{
\code{\link{grand_mean_center}}
}
