% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bruceR-stats_5_advance.R
\name{med_summary}
\alias{med_summary}
\title{Tidy report of mediation analysis.}
\usage{
med_summary(model, digits = 3, file = NULL)
}
\arguments{
\item{model}{Mediation model built with \code{\link[mediation:mediate]{mediation::mediate()}}.}

\item{digits}{Number of decimal places of output. Defaults to \code{3}.}

\item{file}{File name of MS Word (\code{".doc"}).}
}
\value{
Invisibly return a data frame containing the results.
}
\description{
Tidy report of mediation analysis, which is performed using \code{\link[mediation:mediate]{mediation::mediate()}}.
}
\examples{
\dontrun{

library(mediation)
# ?mediation::mediate

## Example 1: OLS Regression
## Bias-corrected and accelerated (BCa) bootstrap confidence intervals

## Hypothesis: Solar radiation -> Ozone -> Daily temperature
lm.m = lm(Ozone ~ Solar.R + Month + Wind, data=airquality)
lm.y = lm(Temp ~ Ozone + Solar.R + Month + Wind, data=airquality)
set.seed(123)  # set a random seed for reproduction
med = mediate(lm.m, lm.y,
            treat="Solar.R", mediator="Ozone",
            sims=1000, boot=TRUE, boot.ci.type="bca")
med_summary(med)

## Example 2: Multilevel Linear Model (Linear Mixed Model)
## (models must be fit using "lme4::lmer" rather than "lmerTest::lmer")
## Monte Carlo simulation (quasi-Bayesian approximation)
## (bootstrap method is not applicable to "lmer" models)

## Hypothesis: Crips -> Sweetness -> Preference (for carrots)
data = lmerTest::carrots  # long-format data
data = na.omit(data)  # omit missing values
lmm.m = lme4::lmer(Sweetness ~ Crisp + Gender + Age + (1 | Consumer), data=data)
lmm.y = lme4::lmer(Preference ~ Sweetness + Crisp + Gender + Age + (1 | Consumer), data=data)
set.seed(123)  # set a random seed for reproduction
med.lmm = mediate(lmm.m, lmm.y,
                  treat="Crisp", mediator="Sweetness",
                  sims=1000)
med_summary(med.lmm)
}

}
\seealso{
\code{\link[=PROCESS]{PROCESS()}}
}
