% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cards.R
\name{bs4SocialCard}
\alias{bs4SocialCard}
\title{AdminLTE3 social card}
\usage{
bs4SocialCard(..., src = NULL, title = NULL, subtitle = NULL,
  width = 6, height = NULL, collapsible = TRUE, closable = TRUE,
  comments = NULL, footer = NULL)
}
\arguments{
\item{...}{Body content. May include \link{attachmentBlock} for instance.}

\item{src}{Header image, if any.}

\item{title}{Card title.}

\item{subtitle}{card subtitle.}

\item{width}{Card width (between 1 and 12).}

\item{height}{Card height.}

\item{collapsible}{If TRUE, display a button in the upper right that allows the user to collapse the card.}

\item{closable}{If TRUE, display a button in the upper right that allows the user to close the card.}

\item{comments}{Slot for \link{cardComment}.}

\item{footer}{Card footer, if any.}
}
\description{
Create social card
}
\examples{
if (interactive()) {
 library(shiny)
 library(bs4Dash)
 shinyApp(
  ui = bs4DashPage(
    navbar = bs4DashNavbar(),
    sidebar = bs4DashSidebar(
     bs4SidebarMenu(
       bs4SidebarHeader("Main content"),
       bs4SidebarMenuItem(
         "Social Card",
         tabName = "social_card",
         icon = "desktop"
       )
      )
    ),
    footer = bs4DashFooter(),
    body = bs4DashBody(
     bs4TabItems(
       bs4TabItem(
         tabName = "profile_card",
         bs4SocialCard(
          title = "Social Card",
          subtitle = "example-01.05.2018",
          src = "https://adminlte.io/themes/AdminLTE/dist/img/user4-128x128.jpg",
          "Some text here!",
          comments = tagList(
           lapply(X = 1:10, FUN = function(i) {
             cardComment(
              src = "https://adminlte.io/themes/AdminLTE/dist/img/user3-128x128.jpg",
              title = paste("Comment", i),
              date = "01.05.2018",
              paste0("The ", i, "-th comment")
             )
            })
          ),
          footer = "The footer here!"
         )
       )
     )
   ),
   title = "socialCard"
  ),
  server = function(input, output) { }
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
