% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/useful-items.R
\name{bs4Accordion}
\alias{bs4Accordion}
\title{Create a Bootstrap 4 accordion}
\usage{
bs4Accordion(..., id)
}
\arguments{
\item{...}{Slot for \link{bs4AccordionItem}.}

\item{id}{Unique accordion id.}
}
\description{
Beautiful accordion from AdminLTE3
}
\examples{
if(interactive()){
 library(shiny)
 library(bs4Dash)
 
 shiny::shinyApp(
   ui = bs4DashPage(
     navbar = bs4DashNavbar(),
     sidebar = bs4DashSidebar(),
     controlbar = bs4DashControlbar(),
     footer = bs4DashFooter(),
     title = "test",
     body = bs4DashBody(
      bs4Accordion(
       id = "accordion",
       bs4AccordionItem(
        id = "item1",
        title = "Item 1", 
        status = "danger",
        "Anim pariatur cliche reprehenderit, enim 
        eiusmod high life accusamus terry richardson ad 
        squid. 3 wolf moon officia aute, non cupidatat 
        skateboard dolor brunch. Food truck quinoa nesciunt 
        laborum eiusmod. Brunch 3 wolf moon tempor, sunt 
        aliqua put a bird on it squid single-origin coffee 
        nulla assumenda shoreditch et. Nihil anim keffiyeh 
        helvetica, craft beer labore wes anderson cred 
        nesciunt sapiente ea proident. Ad vegan excepteur 
        butcher vice lomo. Leggings occaecat craft beer farm-to-table, 
        raw denim aesthetic synth nesciunt you probably haven't 
        heard of them accusamus labore sustainable VHS"
       ),
       bs4AccordionItem(
        id = "item2",
        title = "Item 2", 
        status = "warning",
        "Anim pariatur cliche reprehenderit, enim 
        eiusmod high life accusamus terry richardson ad 
        squid. 3 wolf moon officia aute, non cupidatat 
        skateboard dolor brunch. Food truck quinoa nesciunt 
        laborum eiusmod. Brunch 3 wolf moon tempor, sunt 
        aliqua put a bird on it squid single-origin coffee 
        nulla assumenda shoreditch et. Nihil anim keffiyeh 
        helvetica, craft beer labore wes anderson cred 
        nesciunt sapiente ea proident. Ad vegan excepteur 
        butcher vice lomo. Leggings occaecat craft beer farm-to-table, 
        raw denim aesthetic synth nesciunt you probably haven't 
        heard of them accusamus labore sustainable VHS"
       )
      )
     )
   ),
   server = function(input, output) {}
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
