% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/useful-items.R
\name{bs4ProgressBar}
\alias{bs4ProgressBar}
\title{Create a Bootstrap 4 progress bar}
\usage{
bs4ProgressBar(
  value,
  min = 0,
  max = 100,
  vertical = FALSE,
  striped = FALSE,
  status = c("primary", "warning", "danger", "info", "success"),
  size = NULL
)
}
\arguments{
\item{value}{Progress bar value}

\item{min}{Progress bar minimum value.}

\item{max}{Progress bar maximum value.}

\item{vertical}{Whether to display the progress bar in vertical mode. FALSE by default.}

\item{striped}{Whether the progress bar is striped or not. FALSE by default.}

\item{status}{Progress bar status. "primary", "success", "warning", "danger" or "info".}

\item{size}{Progress bar size. NULL, "sm", "xs" or "xxs".}
}
\description{
AdminLTE3 progress bar
}
\examples{
if(interactive()){
 library(shiny)
 library(bs4Dash)
 
 shiny::shinyApp(
   ui = bs4DashPage(
     navbar = bs4DashNavbar(),
     sidebar = bs4DashSidebar(),
     controlbar = bs4DashControlbar(),
     footer = bs4DashFooter(),
     title = "test",
     body = bs4DashBody(
       title = "Progress bars",
       bs4Card(
        title = "Progress bars",
        footer = tagList(
          bs4ProgressBar(
          value = 5,
          size = "xxs",
          striped = FALSE,
          status = "info"
         ),
         bs4ProgressBar(
          value = 25,
          striped = TRUE,
          status = "warning"
         )
        ),
        bs4ProgressBar(
         value = 80,
         vertical = TRUE,
         status = "success"
        ),
        bs4ProgressBar(
         value = 100,
         vertical = TRUE,
         striped = TRUE,
         size = "sm",
         status = "danger"
        )
       )
     )
   ),
   server = function(input, output) {}
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
