% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dashboardPage.R, R/aliases.R
\name{bs4DashPage}
\alias{bs4DashPage}
\alias{dashboardPage}
\title{Create a Boostrap 4 dashboard page}
\usage{
bs4DashPage(
  header,
  sidebar,
  body,
  controlbar = NULL,
  footer = NULL,
  title = NULL,
  skin = NULL,
  freshTheme = NULL,
  preloader = NULL,
  options = NULL,
  fullscreen = FALSE,
  help = FALSE,
  dark = FALSE,
  scrollToTop = FALSE
)

dashboardPage(
  header,
  sidebar,
  body,
  controlbar = NULL,
  footer = NULL,
  title = NULL,
  skin = NULL,
  freshTheme = NULL,
  preloader = NULL,
  options = NULL,
  fullscreen = FALSE,
  help = FALSE,
  dark = FALSE,
  scrollToTop = FALSE
)
}
\arguments{
\item{header}{Slot for \link{bs4DashNavbar}.}

\item{sidebar}{Slot for \link{bs4DashSidebar}.}

\item{body}{Slot for \link{bs4DashBody}.}

\item{controlbar}{Slot for \link{bs4DashControlbar} (right side).}

\item{footer}{Slot for \link{bs4DashFooter}.}

\item{title}{App title.}

\item{skin}{Deprecated skin parameters. See \link{skinSelector} for live theming.}

\item{freshTheme}{A skin powered by the fresh package. Not compatible with skin.
See \url{https://dreamrs.github.io/fresh/articles/vars-shinydashboard.html}.}

\item{preloader}{bs4Dash uses waiter (see \url{https://waiter.john-coene.com/#/}).
Pass a list like \code{list(html = spin_1(), color = "#333e48")} to configure \link[waiter]{waiterShowOnLoad} (refer to
the package help for all styles).}

\item{options}{Extra option to overwrite the vanilla AdminLTE configuration. See
\url{https://adminlte.io/themes/AdminLTE/documentation/index.html#adminlte-options}.
Expect a list.}

\item{fullscreen}{Whether to allow fullscreen feature in the navbar. Default to FALSE.}

\item{help}{Whether to enable/disable popovers and tooltips. This allows to seamlessly use
\link{tooltip} and \link{popover} without having to individually toggle them. Default to FALSE.
if TRUE, a help icon is display in the navigation bar.}

\item{dark}{Whether to display toggle to switch between dark and light mode in the \link{dashboardHeader}.
Default to FALSE, app starts in light mode, with possibility to switch to dark. 
If TRUE, the app starts in dark with possibility to switch back to light. If NULL,
not toggle is shown and the app starts in light, as it has always been.}

\item{scrollToTop}{Whether to display a scroll to top button whenever the page height is too large.
Default to FALSE.}
}
\description{
Build an adminLTE3 dashboard page
}
\examples{
if (interactive()) {
  library(shiny)
  library(bs4Dash)
  library(fresh)

  shinyApp(
    ui = dashboardPage(
      freshTheme = create_theme(
        bs4dash_vars(
          navbar_light_color = "#bec5cb",
          navbar_light_active_color = "#FFF",
          navbar_light_hover_color = "#FFF"
        ),
        bs4dash_yiq(
          contrasted_threshold = 10,
          text_dark = "#FFF",
          text_light = "#272c30"
        ),
        bs4dash_layout(
          main_bg = "#353c42"
        ),
        bs4dash_sidebar_light(
          bg = "#272c30",
          color = "#bec5cb",
          hover_color = "#FFF",
          submenu_bg = "#272c30",
          submenu_color = "#FFF",
          submenu_hover_color = "#FFF"
        ),
        bs4dash_status(
          primary = "#5E81AC", danger = "#BF616A", light = "#272c30"
        ),
        bs4dash_color(
          gray_900 = "#FFF", white = "#272c30"
        )
      ),
      options = NULL,
      header = dashboardHeader(
        title = dashboardBrand(
          title = "My dashboard",
          color = "primary",
          href = "https://adminlte.io/themes/v3",
          image = "https://adminlte.io/themes/v3/dist/img/AdminLTELogo.png"
        )
      ),
      sidebar = dashboardSidebar(),
      body = dashboardBody(
        box(status = "danger"),
        box(status = "primary"),
        box(status = "orange")
      ),
      controlbar = dashboardControlbar(),
      title = "DashboardPage"
    ),
    server = function(input, output) { }
  )
}
}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
