% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ppc.R
\name{plot_ppc.bgmfit}
\alias{plot_ppc.bgmfit}
\alias{plot_ppc}
\title{Perform posterior predictive distribution checks}
\usage{
\method{plot_ppc}{bgmfit}(
  model,
  resp = NULL,
  deriv = 0,
  usesavedfuns = FALSE,
  clearenvfuns = FALSE,
  envir = NULL,
  ...
)

plot_ppc(model, ...)
}
\arguments{
\item{model}{An object of class \code{bgmfit}.}

\item{resp}{A character string to specify response variable when processing
posterior draws for the univariate-by-subgroup and multivariate models (see
\code{\link[=bsitar]{bsitar()}} for details on fitting univariate-by-subgroup and
multivariate models). For univariate model, \code{resp = NULL} (default).
Note that argument \code{resp} must be specified for the
univariate-by-subgroup and multivariate models otherwise it will result in
an error. On the other hand, argument \code{resp} must be \code{NULL} for
the univariate model. The default setting is \code{resp = NULL} assuming a
univariate model.}

\item{deriv}{An integer to indicate whether to estimate distance curve or
derivatives (velocity and acceleration curves). Default \code{deriv = 0} is
for the distance curve, \code{deriv = 1} for velocity curve, and
\code{deriv = 2} for the acceleration curve.}

\item{usesavedfuns}{A logical (default \code{FALSE}) to indicate whether to
use the already exposed and saved \code{Stan} functions. This is for
internal use when testing the function and not used routinely.}

\item{clearenvfuns}{A logical (default \code{FALSE}) to indicate whether to
clear the exposed function from the environment.}

\item{envir}{Environment of function evaluation. The default is \code{NULL}
which will set \code{parent.frame()} as default environment. Note that
since most of post processing functions are based on \pkg{brms}, it is
strongly advised to set \code{globalenv()} (or \code{.GlobalEnv}) as
environment. This is particularly true for derivatives such as velocity
curve.}

\item{...}{Additional arguments passed to the \code{\link[brms:pp_check.brmsfit]{brms::pp_check.brmsfit()}}
function. Please see \code{\link[brms:pp_check.brmsfit]{brms::pp_check.brmsfit()}} for details.}
}
\value{
A ggplot object that can be further customized using the
ggplot2 package.
}
\description{
Perform posterior predictive checks with the help
of the \pkg{bayesplot} package.
}
\details{
The \strong{plot_ppc()} is a wrapper around the \code{\link[brms:pp_check.brmsfit]{brms::pp_check()}}.
}
\examples{

# Fit Bayesian SITAR model 

# To avoid fitting the model which takes time, the model  
# fit has already been saved as 'berkeley_mfit.rda' file.
# See examples section of the main function for details on the model fit.

model <- berkeley_mfit

plot_ppc(model, ndraws = 100)

}
\author{
Satpal Sandhu  \email{satpal.sandhu@bristol.ac.uk}
}
