% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_draws.R
\name{predict_draws.bgmfit}
\alias{predict_draws.bgmfit}
\alias{predict_draws}
\title{Predicted values (draws) from the posterior predictive distribution}
\usage{
\method{predict_draws}{bgmfit}(
  model,
  newdata = NULL,
  resp = NULL,
  ndraws = NULL,
  re_formula = NULL,
  numeric_cov_at = NULL,
  levels_id = NULL,
  ipts = NULL,
  deriv = 0,
  deriv_model = TRUE,
  summary = TRUE,
  robust = FALSE,
  probs = c(0.025, 0.975),
  xrange = NULL,
  parms_eval = FALSE,
  parms_method = "getPeak",
  idata_method = "m1",
  usesavedfuns = FALSE,
  clearenvfuns = FALSE,
  envir = NULL,
  ...
)

predict_draws(model, ...)
}
\arguments{
\item{model}{An object of class \code{bgmfit}.}

\item{newdata}{An optional data frame to be used in predictions. If
\code{NULL} (default), the model fit.}

\item{resp}{A character string to specify response variable when processing
posterior draws for the univariate-by-subgroup and multivariate models (see
\code{\link[=bsitar]{bsitar()}} for details on fitting univariate-by-subgroup and
multivariate models). For univariate model, \code{resp = NULL} (default).
Note that argument \code{resp} must be specified for the
univariate-by-subgroup and multivariate models otherwise it will result in
an error. On the other hand, argument \code{resp} must be \code{NULL} for
the univariate model. The default setting is \code{resp = NULL} assuming a
univariate model.}

\item{ndraws}{Positive integer indicating the number of posterior draws to be
used in estimation. If \code{NULL} (default), all draws are used.}

\item{re_formula}{Option to indicate whether or not to include the
individual/group-level effects in the estimation. When \code{NA} (default),
the individual-level effects are excluded and therefore population average
growth parameters are computed. When \code{NULL}, individual-level effects
are included in the computation and hence the growth parameters estimates
returned are individual-specific. In both situations, (i.e,, \code{NA} or
\code{NULL}), continuous and factor covariate(s) are appropriately included
in the estimation. The continuous covariates by default are set to their
means (see \code{numeric_cov_at} for details) whereas factor covariates are
left unaltered thereby allowing estimation of (factor) covariate specific
population average and individual-specific growth parameter at mean value
of continous covaristes(s).}

\item{numeric_cov_at}{An optional argument to specify the value of continuous
covariate(s). The default \code{NULL} option set the continuous
covariate(s) at their mean. Alternatively, a named list can be
supplied to manually set these values. For example, \code{numeric_cov_at =
  list(xx = 2)} will set the continuous covariate varibale 'xx' at 2. The
argument \code{numeric_cov_at} is ignored when no continuous covariate is
included in the model.}

\item{levels_id}{An optional argument to specify the \code{ids} for
hierarchical model (default \code{NULL}). It is used only when model is
applied to the data with 3 or more levels of hierarchy. For a two level
model, the \code{id} for second level is automatically inferred from the
model fit. Even for 3 or higher level model, ids are inferred from the
model fit but under the assumption that hierarchy is specified from
lower to upper levels i.e, \code{id} followed by \code{study} assuming that
\code{id} is nested within the \code{study} However, it is not guaranteed
that these ids are sorted correctly. Therefore, it is better to set them
manually.}

\item{ipts}{An integer to set the length of the predictor variable to get a
smooth velocity curve. The \code{NULL} will return original values whereas
an integer such as \code{ipts = 10} (default) will interpolate the
predictor. It is important to note that these interpolations do not alter
the range of predictor when calculating population average and/or the
individual specific growth curves.}

\item{deriv}{An integer to indicate whether to estimate distance curve or
derivatives (velocity and acceleration curves). Default \code{deriv = 0} is
for the distance curve, \code{deriv = 1} for velocity curve, and
\code{deriv = 2} for the acceleration curve.}

\item{deriv_model}{A logical (default \code{TRUE}) to indicate whether to
estimate model based derivatives or from the differentiation of the
distance curve. When model is fit with \code{decomp = 'QR'}, the only
approach available to estimate derivatives by the  differentiation of the
distance curve.}

\item{summary}{A logical (default \code{TRUE}) indicating whether only the
Estimate should be returned or Estimate along with SE and CI should be
computed. Setting this option to \code{FALSE} will reduce the computation
time but no SE or CI estimates will be available.}

\item{robust}{If \code{FALSE} (the default) the mean is used as the measure
of central tendency and the standard deviation as the measure of
variability. If \code{TRUE}, the median and the median absolute deviation
(MAD) are applied instead. Ignored if summary is \code{FALSE}.}

\item{probs}{The percentiles to be computed by the \code{quantile}
function. Only used if \code{summary} is \code{TRUE}.}

\item{xrange}{An integer to set the predictor range (i.e., age) when
executing the interpolation via \code{ipts}. The default \code{NULL} sets
the individual specific predictor range whereas code \code{xrange = 1} sets
same range for all individuals within the higher order grouping variable
(e.g., study). Code \code{xrange  = 2} sets the identical range across the
entire sample. Lastly, a paired numeric values can be supplied e.g.,
\code{xrange = c(6, 20)} to set the range between 6 and 20.}

\item{parms_eval}{A logical (default \code{FALSE}) to specify whether or not
to get growth parameters on the fly.}

\item{parms_method}{A character to specify the method used to when evaluating
\code{parms_eval}. The default is \code{getPeak} which uses the
\code{\link[sitar:getPeakTrough]{sitar::getPeak()}} function from the \code{sitar} package. The alternative
option is \code{findpeaks} that uses the \code{\link[pracma:findpeaks]{pracma::findpeaks()}} function
function from the \code{pracma} package. Note that the argument
\code{parms_method} is currently ignored.}

\item{idata_method}{A character string to indicate the interpolation method.
Options are \emph{method 1} (specified as  \code{'m1'}, default) and
\emph{method 2} (specified as \code{'m2'}). The \emph{method 1}
(\code{'m1'}) is adapted from the the \pkg{iapvbs} package and is
documented here \url{https://rdrr.io/github/Zhiqiangcao/iapvbs/src/R/exdata.R}.
The \emph{method 2} (\code{'m2'}) is adapted from the the \pkg{JMbayes}
package and is documented here
\url{https://github.com/drizopoulos/JMbayes/blob/master/R/dynPred_lme.R}.}

\item{usesavedfuns}{A logical (default \code{FALSE}) to indicate whether to
use the already exposed and saved \code{Stan} functions. This is for
internal use when testing the function and not used routinely.}

\item{clearenvfuns}{A logical (default \code{FALSE}) to indicate whether to
clear the exposed function from the environment.}

\item{envir}{Environment of function evaluation. The default is \code{NULL}
which will set \code{parent.frame()} as default environment. Note that
since most of post processing functions are based on \pkg{brms}, it is
strongly advised to set \code{globalenv()} (or \code{.GlobalEnv}) as
environment. This is particularly true for derivatives such as velocity
curve.}

\item{...}{Additional arguments passed to the \code{\link[brms:predict.brmsfit]{brms::predict.brmsfit()}}
function. Please see \code{\link[brms:predict.brmsfit]{brms::predict.brmsfit()}} for details on various
options available.}
}
\value{
An array of predicted response values. See \code{\link[brms:predict.brmsfit]{brms::predict.brmsfit()}}
for details.
}
\description{
The \strong{predict_draws()} is a wrapper around the
\code{\link[brms:predict.brmsfit]{brms::predict.brmsfit()}} function to obtain predicted values (and their
summary) from the posterior distribution. See \code{\link[brms:predict.brmsfit]{brms::predict.brmsfit()}} for
details.
}
\details{
The \strong{predict_draws()} function computed the fitted values
from the posterior distribution. The \code{\link[brms:predict.brmsfit]{brms::predict.brmsfit()}} function
from the \pkg{brms} package can used to get the predicted (distance) values
when outcome (e.g., height) is untransformed. However, when the outcome is
log or square root transformed, the \code{\link[brms:predict.brmsfit]{brms::predict.brmsfit()}} function will
return the fitted curve on the log or square root scale whereas the
\strong{predict_draws()} function returns the fitted values on the original
scale. Furthermore, the \strong{predict_draws()} also compute the first
derivative of (velocity) that too on the original scale after making
required back-transformation. Except for these differences, both these
functions (i.e., \code{\link[brms:predict.brmsfit]{brms::predict.brmsfit()}} and \code{\link[=predict_draws]{predict_draws()}}) work in
the same manner. In other words, user can specify all the options available
in the \code{\link[brms:predict.brmsfit]{brms::predict.brmsfit()}}.
}
\examples{

# Fit Bayesian SITAR model 

# To avoid fitting the model which takes time, the model  
# fit has already been saved as 'berkeley_mfit.rda' file.
# See examples section of the main function for details on the model fit.

model <- berkeley_mfit

# Population average distance curve
predict_draws(model, deriv = 0, re_formula = NA)

\donttest{
# Individual-specific distance curves
predict_draws(model, deriv = 0, re_formula = NULL)

# Population average velocity curve
predict_draws(model, deriv = 1, re_formula = NA)

# Individual-specific velocity curves
predict_draws(model, deriv = 1, re_formula = NULL)
 }

}
\seealso{
\code{\link[brms:predict.brmsfit]{brms::predict.brmsfit()}}
}
\author{
Satpal Sandhu  \email{satpal.sandhu@bristol.ac.uk}
}
