% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/growthparameters.R
\name{growthparameters.bgmfit}
\alias{growthparameters.bgmfit}
\alias{growthparameters}
\title{Estimate growth parameters from the model fit}
\usage{
\method{growthparameters}{bgmfit}(
  model,
  newdata = NULL,
  resp = NULL,
  ndraws = NULL,
  draw_ids = NULL,
  summary = TRUE,
  robust = FALSE,
  re_formula = NA,
  peak = TRUE,
  takeoff = FALSE,
  trough = FALSE,
  acgv = FALSE,
  acgv_velocity = 0.1,
  estimation_method = "fitted",
  allow_new_levels = FALSE,
  sample_new_levels = "uncertainty",
  incl_autocor = TRUE,
  numeric_cov_at = NULL,
  levels_id = NULL,
  avg_reffects = NULL,
  aux_variables = NULL,
  ipts = 10,
  deriv_model = TRUE,
  conf = 0.95,
  xrange = NULL,
  xrange_search = NULL,
  digits = 2,
  seed = 123,
  future = FALSE,
  future_session = "multisession",
  cores = NULL,
  parms_eval = FALSE,
  idata_method = NULL,
  parms_method = "getPeak",
  verbose = FALSE,
  fullframe = NULL,
  dummy_to_factor = NULL,
  usesavedfuns = FALSE,
  clearenvfuns = NULL,
  envir = NULL,
  ...
)

growthparameters(model, ...)
}
\arguments{
\item{model}{An object of class \code{bgmfit}.}

\item{newdata}{An optional data frame to be used in estimation. If
\code{NULL} (default), the \code{newdata} is retrieved from the
\code{model}.}

\item{resp}{A character string (default \code{NULL}) to specify response
variable when processing posterior draws for the \code{univariate_by} and
\code{multivariate} models. See \code{\link[=bsitar]{bsitar()}} for details on
\code{univariate_by} and \code{multivariate} models}

\item{ndraws}{A positive integer indicating the number of posterior draws to
be used in estimation. If \code{NULL} (default), all draws are used.}

\item{draw_ids}{An integer indicating the specific posterior draw(s)
to be used in estimation (default \code{NULL}).}

\item{summary}{A logical indicating whether only the estimate should be
computed (\code{TRUE}, default), or estimate along with SE and CI should be
returned (\code{FALSE}). Setting \code{summary} as \code{FALSE} will
increase the computation time.}

\item{robust}{A logical to specify the summarize options. If \code{FALSE}
(the default) the mean is used as the measure of central tendency and the
standard deviation as the measure of variability. If \code{TRUE}, the
median and the median absolute deviation (MAD) are applied instead. Ignored
if \code{summary} is \code{FALSE}.}

\item{re_formula}{Option to indicate whether or not to include the
individual/group-level effects in the estimation. When \code{NA} (default),
the individual-level effects are excluded and therefore population average
growth parameters are computed. When \code{NULL}, individual-level effects
are included in the computation and hence the growth parameters estimates
returned are individual-specific. In both situations, (i.e,, \code{NA} or
\code{NULL}), continuous and factor covariate(s) are appropriately included
in the estimation. The continuous covariates by default are set to their
means (see \code{numeric_cov_at} for details) whereas factor covariates are
left unaltered thereby allowing estimation of covariate specific population
average and individual-specific growth parameter.}

\item{peak}{A logical (default \code{TRUE}) to indicate whether or
not to calculate the age at peak velocity (APGV) and the peak velocity
(PGV) parameters.}

\item{takeoff}{A logical (default \code{FALSE}) to indicate whether
or not to calculate the age at takeoff velocity (ATGV) and the takeoff
growth velocity (TGV) parameters.}

\item{trough}{A logical (default \code{FALSE}) to indicate whether or
not to calculate the age at cessation of growth velocity (ACGV) and the
cessation of growth velocity (CGV) parameters.}

\item{acgv}{A logical (default \code{FALSE}) to indicate whether or not to
calculate the age at cessation of growth velocity from the velocity curve.
If \code{TRUE}, age at cessation of growth velocity (ACGV) and the
cessation growth velocity (CGV) are  calculated based on the percentage of
the peak growth velocity as defined by the \code{acgv_velocity} argument
(see below). The \code{acgv_velocity} is typically set at 10 percent of the
peak growth velocity. The ACGV and CGV are calculated along with the the
uncertainty (SE and CI) around the ACGV and CGV parameters.}

\item{acgv_velocity}{Specify the percentage of the peak growth velocity to be
used when estimating \code{acgv}. The default value is \code{0.10} i.e.,
10 percent of the peak growth velocity.}

\item{estimation_method}{A character string to specify the estimation method
when calculating the velocity from the posterior draws. The \code{'fitted'}
method internally calls the \code{\link[=fitted_draws]{fitted_draws()}} whereas the option
\code{predict} calls the \code{\link[=predict_draws]{predict_draws()}}. See
\code{\link[brms:fitted.brmsfit]{brms::fitted.brmsfit()}} and \code{\link[brms:predict.brmsfit]{brms::predict.brmsfit()}} for derails.}

\item{allow_new_levels}{A flag indicating if new levels of group-level
effects are allowed (defaults to \code{FALSE}). Only relevant if
\code{newdata} is provided.}

\item{sample_new_levels}{Indicates how to sample new levels for grouping
factors specified in \code{re_formula}. This argument is only relevant if
\code{newdata} is provided and \code{allow_new_levels} is set to
\code{TRUE}. If \code{"uncertainty"} (default), each posterior sample for a
new level is drawn from the posterior draws of a randomly chosen existing
level. Each posterior sample for a new level may be drawn from a different
existing level such that the resulting set of new posterior draws
represents the variation across existing levels. If \code{"gaussian"},
sample new levels from the (multivariate) normal distribution implied by the
group-level standard deviations and correlations. This options may be useful
for conducting Bayesian power analysis or predicting new levels in
situations where relatively few levels where observed in the old_data. If
\code{"old_levels"}, directly sample new levels from the existing levels,
where a new level is assigned all of the posterior draws of the same
(randomly chosen) existing level.}

\item{incl_autocor}{A flag indicating if correlation structures originally
specified via \code{autocor} should be included in the predictions.
Defaults to \code{TRUE}.}

\item{numeric_cov_at}{An optional (named list) argument to specify the value
of continuous covariate(s). The default \code{NULL} option set the
continuous covariate(s) at their mean. Alternatively, a named list can be
supplied to manually set these values. For example, \code{numeric_cov_at =
  list(xx = 2)} will set the continuous covariate varibale 'xx' at 2. The
argument \code{numeric_cov_at} is ignored when no continuous covariate is
included in the model.}

\item{levels_id}{An optional argument to specify the \code{ids} for
hierarchical model (default \code{NULL}). It is used only when model is
applied to the data with 3 or more levels of hierarchy. For a two level
model, the \code{levels_id} is automatically inferred from the model fit.
Even for 3 or higher level model, the \code{levels_id} is inferred from the
model fit but under the assumption that hierarchy is specified from lowest
to upper most level i.e, \code{id} followed by \code{study} where \code{id}
is nested within the \code{study} Note that it is not guaranteed that the
\code{levels_id} is sorted correctly, and therefore it is better to set it
manually when fitting a model with three or more levels of hierarchy.}

\item{avg_reffects}{An optional argument (default \code{NULL}) to calculate
(marginal/average) curves and growth parameters (such as APGV and PGV). If
specified, it must be a named list indicating the \code{over} (typically
level 1 predictor, such as age), \code{feby} (fixed effects, typically a
factor variable), and  \code{reby} (typically \code{NULL} indicating that
parameters are integrated over the random effects) such as
\code{avg_reffects = list(feby = 'study', reby = NULL, over = 'age'}.}

\item{aux_variables}{An optional argument to specify the variable(s) that can
be passed to the \code{ipts} argument (see below). This is useful when
fitting location scale models and measurement error models. An
indication to use \code{aux_variables} is when post processing functions
throw an error such as \code{variable 'x' not found either 'data' or
 'data2'}}

\item{ipts}{An integer to set the length of the predictor variable to get a
smooth velocity curve. The \code{NULL} will return original values whereas
an integer such as \code{ipts = 10} (default) will interpolate the
predictor. It is important to note that these interpolations do not alter
the range of predictor when calculating population average and/or the
individual specific growth curves.}

\item{deriv_model}{A logical to specify whether to estimate velocity curve
from the derivative function, or the differentiation of the distance curve.
The argument \code{deriv_model} is set to \code{TRUE} for those functions
which need velocity curve such as \code{growthparameters()} and
\code{plot_curves()}, and \code{NULL} for functions which explicitly use
the distance curve (i.e., fitted values) such as \code{loo_validation()}
and \code{plot_ppc()}.}

\item{conf}{A numeric value (default \code{0.95}) to compute CI. Internally,
the \code{conf} is translated into a paired probability values as
\code{c((1 - conf)/2, 1 - (1 - conf) / 2)}. For \code{conf = 0.95}, this
will compute 95\% CI and the variables with lower and upper limits will be
named as \code{Q.2.5} and \code{Q.97.5}.}

\item{xrange}{An integer to set the predictor range (i.e., age) when
executing the interpolation via \code{ipts}. The default \code{NULL} sets
the individual specific predictor range whereas code \code{xrange = 1} sets
identical range for individuals within the same higher grouping variable
(e.g., study). Code \code{xrange  = 2} sets the identical range across the
entire sample. Lastly, a paired numeric values can be supplied e.g.,
\code{xrange = c(6, 20)} to set the range within those values.}

\item{xrange_search}{A vector of length two, or a character string
\code{'range'} to set the range of predictor variable (\code{x} ) within
which growth parameters are searched. This is useful when there is more
than one peak and user wants to summarize peak within a given range of the
\code{x} variable. Default \code{xrange_search = NULL}.}

\item{digits}{An integer (default \code{2}) to set the decimal argument for
the \code{\link[base:Round]{base::round()}} function.}

\item{seed}{An integer (default \code{123}) that is passed to the estimation
method.}

\item{future}{A logical (default \code{FALSE}) to specify whether or not to
perform parallel computations. If set to \code{TRUE}, the
\code{\link[future.apply:future_lapply]{future.apply::future_sapply()}} function is used to summarize draws.}

\item{future_session}{A character string to set the session type when
\code{future = TRUE}. The \code{'multisession'} (default) options sets the
multisession whereas the \code{'multicore'} sets the multicore session.
Note that option \code{'multicore'} is not supported on Windows systems.
For more details, see \code{\link[future.apply:future_lapply]{future.apply::future_sapply()}}.}

\item{cores}{Number of cores to be used when running the parallel
computations (if \code{future = TRUE}). On non-Windows systems this
argument can be set globally via the mc.cores option. For the default
\code{NULL} option, the number of cores are set automatically by calling
the \code{\link[future:re-exports]{future::availableCores()}}. The number of cores used are the maximum
number of cores avaialble minus one, i.e., \code{future::availableCores() -
  1}.}

\item{parms_eval}{A logical to specify whether or not to get growth
parameters on the fly. This is for internal use only and mainly needed for
compatibility across internal functions.}

\item{idata_method}{A character string to indicate the interpolation method.
The number of of interpolation points is set up the \code{ipts} argument.
Options available for \code{idata_method} are \emph{method 1} (specified as
\code{'m1'}) and \emph{method 2} (specified as \code{'m2'}). The
\emph{method 1} (\code{'m1'}) is adapted from the the \pkg{iapvbs} package
and is documented here
\url{https://rdrr.io/github/Zhiqiangcao/iapvbs/src/R/exdata.R}
whereas \emph{method 2} (\code{'m2'}) is based on the \pkg{JMbayes}
package as documented here
\url{https://github.com/drizopoulos/JMbayes/blob/master/R/dynPred_lme.R}.
The \code{'m1'} method works by internally constructing the data frame based
on the model configuration whereas the method \code{'m2'} uses the exact
data frame used in model fit and can be accessed via \code{fit$data}. If
\code{idata_method = NULL, default}, then method \code{'m2'} is
automatically set. Note that method \code{'m1'} might fail in some cases
when model involves covariates particularly when model is fit as
\code{univariate_by}. Therefore, it is advised to switch to method
\code{'m2'} in case \code{'m1'} results in error.}

\item{parms_method}{A character to specify the method used to when evaluating
\code{parms_eval}. The default is \code{getPeak} which uses the
\code{\link[sitar:getPeakTrough]{sitar::getPeak()}} function from the \code{sitar} package. The alternative
option is \code{findpeaks} that uses the \code{\link[pracma:findpeaks]{pracma::findpeaks()}} function
function from the \code{pracma} package. This is for internal use only and
mainly needed for compatibility across internal functions.}

\item{verbose}{An optional argument (logical, default \code{FALSE}) to
indicate whether to print information collected during setting up the
object(s).}

\item{fullframe}{A logical to indicate whether to return \code{fullframe}
object in which \code{newdata} is bind to the summary estimates. Note that
\code{fullframe} can not be combined with \code{summary = FALSE}.
Furthermore, \code{fullframe} can only be used when \code{idata_method =
  'm2'}. A particular use case is when fitting \code{univariate_by} model.
The \code{fullframe} is mainly for internal use only.}

\item{dummy_to_factor}{A named list (default \code{NULL}) that is used to
convert dummy variables into a factor variable. The named elements are
\code{factor.dummy}, \code{factor.name}, and \code{factor.level}. The
\code{factor.dummy} is a vector of character strings that need to be
converted to a factor variable whereas the \code{factor.name} is a single
character string that is used to name the newly created factor variable.
The \code{factor.level} is used to name the levels of newly created factor.
When \code{factor.name} is \code{NULL}, then the factor name is internally
set as \code{'factor.var'}. If \code{factor.level} is \code{NULL}, then
names of factor levels are take from the \code{factor.dummy} i.e., the
factor levels are assigned same name as \code{factor.dummy}. Note that when
\code{factor.level} is not \code{NULL}, its length must be same as the
length of the \code{factor.dummy}.}

\item{usesavedfuns}{A logical (default \code{FALSE}) to indicate whether to
use the already exposed and saved \code{Stan} functions. This is for
internal purposes only and mainly used during the testing of the functions
and therefore should not be used by users as it might lead to unreliable
estimates.}

\item{clearenvfuns}{A logical to indicate whether to clear the exposed
function from the environment (\code{TRUE}) or not (\code{FALSE}). If
\code{NULL} (default), then \code{clearenvfuns} is set as \code{TRUE} when
\code{usesavedfuns} is \code{TRUE}, and \code{FALSE} if \code{usesavedfuns}
is \code{FALSE}.}

\item{envir}{Environment used for function evaluation. The default is
\code{NULL} which will set \code{parent.frame()} as default environment.
Note that since most of post processing functions are based on \pkg{brms},
the functions needed for evaluation should be in the \code{.GlobalEnv}.
Therefore, it is strongly recommended to set \code{ envir = globalenv()}
(or \code{envir = .GlobalEnv}). This is particularly true for the
derivatives such as velocity curve.}

\item{...}{Further arguments passed to \code{brms::fitted.brmsfit()} and
\code{brms::predict()} functions.}
}
\value{
A data frame with either five columns (when \code{summary = TRUE}),
or two columns when \code{summary = False} (assuming \code{re_formual =
  NULL}). The first two columns common to each scenario (\code{summary =
  TRUE/False}) are \code{'Parameter'} and \code{'Estimate'} which define the
name of the growth parameter (e.g., APGV, PGV etc), and estimate. When
\code{summary = TRUE}, the three additional columns are \code{'Est.Error'},
and a paired vector of names defining the lower and upper limits of the
CIs. The CI columns are named as Q with appropriate suffix taken from the
percentiles used to construct these intervals (such as  \code{Q.2.5} and
\code{Q.97.5} where\code{2.5} and  \code{97.5} are the  \code{0.025} and
\code{0.975} percentiles used to compute by the 95\% CI by calling the
quantile function. When \code{re_formual = NULL}, an additional column is
added that denotes the individual identifier (typically \code{id}).
}
\description{
The \strong{growthparameters()} computes population
average and and individual-specific growth parameters (such as age at peak
growth velocity) and the uncertainty (standard error, SE and the credible
interval, CI).
}
\details{
The \strong{growthparameters()} internally calls the
\code{\link[=fitted_draws]{fitted_draws()}} or the \code{\link[=predict_draws]{predict_draws()}} function to estimate the first
derivative based growth parameters for each posterior draw. The growth
parameters estimated are age at peak growth velocity (APGV), peak growth
velocity (PGV), age at takeoff growth velocity (ATGV), takeoff growth
velocity (TGV), age at cessation of growth velocity (ACGV), and the
cessation growth velocity (CGV). The APGV and PGV are estimated by calling
the \code{\link[sitar:getPeakTrough]{sitar::getPeak()}} function whereas the ATGV and TGV are estimated by
using the \code{\link[sitar:getPeakTrough]{sitar::getTakeoff()}} function. The \code{\link[sitar:getPeakTrough]{sitar::getTrough()}} function
is used to estimates ACGV and CGV parameters. The parameters obtained from
each posterior draw are then summarized appropriately to get the estimates
and the uncertainty (SEs and CIs) around these estimates. Please note that
it is not always possible to estimate cessation and takeoff growth
parameters when there are no distinct pre-peak or post-peak troughs.
}
\examples{

# Fit Bayesian SITAR model 

# To avoid mode estimation which takes time, a model fitted to the 
# 'berkeley_mdata' has already been saved as 'berkeley_mfit'. 
# Details on 'berkeley_mdata' and 'berkeley_mfit' are provided in the 
# 'bsitar' function.

model <- berkeley_mfit

# Population average age and velocity during the peak growth spurt
growthparameters(model, re_formula = NA)

\donttest{
# Population average age and velocity during the take-off and the peak 
# growth spurt (APGV, PGV. ATGV, TGV)

growthparameters(model, re_formula = NA, peak = TRUE, takeoff = TRUE)

# Individual-specific age and velocity during the take-off and the peak
# growth spurt (APGV, PGV. ATGV, TGV)

growthparameters(model, re_formula = NULL, peak = TRUE, takeoff = TRUE)
}

}
\author{
Satpal Sandhu  \email{satpal.sandhu@bristol.ac.uk}
}
