% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feed_feed_generators.R
\name{bs_get_feed_generators}
\alias{bs_get_feed_generators}
\title{Get information about a list of feed generators}
\usage{
bs_get_feed_generators(
  feeds,
  user = get_bluesky_user(),
  pass = get_bluesky_pass(),
  auth = bs_auth(user, pass)
)
}
\arguments{
\item{feeds}{Character. Vector of feeds to get.}

\item{user}{Character. User name to log in with. Defaults to \code{get_bluesky_user()}.}

\item{pass}{Character. App password to log in with. Defaults to \code{get_bluesky_pass()}.}

\item{auth}{Authentication information. Defaults to \code{bs_auth(user, pass)}.}
}
\value{
a tibble of feeds
}
\description{
Get information about a list of feed generators
}
\section{Lexicon references}{

\href{https://github.com/bluesky-social/atproto/blob/main/lexicons/app/bsky/feed/getFeedGenerators.json}{feed/getFeedGenerators.json (2023-10-01)}
}

\section{Function introduced}{

\code{v0.0.1} (2023-10-01)
}

\examples{
\dontshow{if (has_bluesky_pass() && has_bluesky_user()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
bs_get_feed_generators('at://did:plc:z72i7hdynmk6r22z27h6tvur/app.bsky.feed.generator/bsky-team')
bs_get_feed_generators(c(
  'at://did:plc:z72i7hdynmk6r22z27h6tvur/app.bsky.feed.generator/bsky-team',
  'at://did:plc:z72i7hdynmk6r22z27h6tvur/app.bsky.feed.generator/whats-hot'
  ))
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=bs_get_feed_generators]{bs_get_feed_generators()}} for more detailed information about one feed generator.
}
\concept{feed}
