% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_mcmc.R
\name{run_mcmc.gssm}
\alias{run_mcmc.gssm}
\alias{run_mcmc.bsm}
\title{Bayesian Inference of Linear-Gaussian State Space Models}
\usage{
\method{run_mcmc}{gssm}(object, n_iter, sim_states = TRUE, type = "full",
  n_burnin = floor(n_iter/2), n_thin = 1, gamma = 2/3,
  target_acceptance = 0.234, S, end_adaptive_phase = TRUE, n_threads = 1,
  seed = sample(.Machine$integer.max, size = 1), ...)

\method{run_mcmc}{bsm}(object, n_iter, sim_states = TRUE, type = "full",
  n_burnin = floor(n_iter/2), n_thin = 1, gamma = 2/3,
  target_acceptance = 0.234, S, end_adaptive_phase = TRUE, n_threads = 1,
  seed = sample(.Machine$integer.max, size = 1), ...)
}
\arguments{
\item{object}{Model object.}

\item{n_iter}{Number of MCMC iterations.}

\item{sim_states}{Simulate states of Gaussian state space models. Default is \code{TRUE}.}

\item{type}{Type of output. Default is \code{"full"}, which returns
samples from the posterior \eqn{p(\alpha, \theta}. Option
\code{"parameters"} samples only parameters \eqn{\theta} (which includes the
regression coefficients \eqn{\beta}). This can be used for faster inference of
\eqn{\theta} only, or as an preliminary run for obtaining
initial values for \code{S}. Option \code{"summary"} does not simulate
states directly but computes the posterior means and variances of states using
fast Kalman smoothing. This is slightly faster, memory  efficient and
more accurate than calculations based on simulation smoother.
\eqn{\theta}. Optional for \code{bsm} objects.}

\item{n_burnin}{Length of the burn-in period which is disregarded from the
results. Defaults to \code{n_iter / 2}.}

\item{n_thin}{Thinning rate. All MCMC algoritms in \code{bssm} use the jump chain 
representation, and the thinning is applied to these blocks. 
This defaults to 1, but for IS-corrected method (\code{method="isc"}), larger 
value is often more effective.}

\item{gamma}{Tuning parameter for the adaptation of RAM algorithm. Must be
between 0 and 1 (not checked).}

\item{target_acceptance}{Target acceptance ratio for RAM. Defaults to 0.234.}

\item{S}{Initial value for the lower triangular matrix of RAM
algorithm, so that the covariance matrix of the Gaussian proposal
distribution is \eqn{SS'}.}

\item{end_adaptive_phase}{If \code{TRUE} (default), $S$ is held fixed after the burnin period.}

\item{n_threads}{Number of threads for state simulation.}

\item{seed}{Seed for the random number generator.}

\item{...}{Ignored.}
}
\description{
Bayesian Inference of Linear-Gaussian State Space Models
}
