% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{mv_gssm}
\alias{mv_gssm}
\title{General multivariate linear-Gaussian state space models}
\usage{
mv_gssm(y, Z, H, T, R, a1, P1, xreg = NULL, beta, state_names, H_prior,
  Z_prior, T_prior, R_prior, obs_intercept, state_intercept)
}
\arguments{
\item{y}{Observations as multivariate time series (or matrix) of length \eqn{n}.}

\item{Z}{System matrix Z of the observation equation. Either a p x m matrix or 
a p x m x n array, or an object which can be coerced to such.}

\item{H}{Covarianc matrix for observational level noise.}

\item{T}{System matrix T of the state equation. Either a m x m matrix or a
m x m x n array, or object which can be coerced to such.}

\item{R}{Lower triangular matrix R the state equation. Either a m x k matrix or a
m x k x n array, or object which can be coerced to such.}

\item{a1}{Prior mean for the initial state as a vector of length m.}

\item{P1}{Prior covariance matrix for the initial state as m x m matrix.}

\item{xreg}{An array containing p covariate matrices with dimensions n x h.}

\item{beta}{matrix of regression coefficients with n columns. Used as an initial
value in MCMC. Defaults to matrix of zeros.}

\item{state_names}{Names for the states.}

\item{H_prior, Z_prior, T_prior, R_prior}{Priors for the NA values in system matrices.}

\item{obs_intercept, state_intercept}{Intercept terms for observation and 
state equations, given as a p times n and m times n matrices.}
}
\value{
Object of class \code{gssm}.
}
\description{
Construct an object of class \code{gssm} by defining the corresponding terms
of the observation and state equation:
}
\details{
\deqn{y_t = D_t + Z_t \alpha_t + H_t \epsilon_t, (\textrm{observation equation})}
\deqn{\alpha_{t+1} = C_t + T_t \alpha_t + R_t \eta_t, (\textrm{transition equation})}

where \eqn{\epsilon_t \sim N(0, I_p)}, \eqn{\eta_t \sim N(0, I_k)} and
\eqn{\alpha_1 \sim N(a_1, P_1)} independently of each other.
}
