% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecast.R
\name{forecast.PosteriorBSVAR}
\alias{forecast.PosteriorBSVAR}
\title{Forecasting using Structural Vector Autoregression}
\usage{
\method{forecast}{PosteriorBSVAR}(posterior, horizon, exogenous_forecast = NULL)
}
\arguments{
\item{posterior}{posterior estimation outcome - an object of class 
PosteriorBSVAR obtained by running the \code{estimate} function.}

\item{horizon}{a positive integer, specifying the forecasting horizon.}

\item{exogenous_forecast}{a matrix of dimension \code{horizon x d} containing 
forecasted values of the exogenous variables.}
}
\value{
A list of class \code{Forecasts} containing the
draws from the predictive density. The output list includes element:

\describe{
 \item{forecasts}{an \code{NxTxS} array with the draws from predictive density}
}
}
\description{
Samples from the joint predictive density of all of the dependent variables at forecast horizons 
from 1 to \code{horizon} specified as an argument of the function.
}
\examples{
# upload data
data(us_fiscal_lsuw)

# specify the model and set seed
set.seed(123)
specification  = specify_bsvar$new(us_fiscal_lsuw, p = 1)

# run the burn-in
burn_in        = estimate(specification, 10)

# estimate the model
posterior      = estimate(burn_in, 20)

# sample from predictive density 1 year ahead
predictive     = forecast(posterior, 4)

# workflow with the pipe |>
############################################################
set.seed(123)
us_fiscal_lsuw |>
  specify_bsvar$new(p = 1) |>
  estimate(S = 10) |> 
  estimate(S = 20) |> 
  forecast(horizon = 4) -> predictive

}
\author{
Tomasz Woźniak \email{wozniak.tom@pm.me}
}
