% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.SDDRidMIX}
\alias{summary.SDDRidMIX}
\title{Provides summary of verifying shocks' normality}
\usage{
\method{summary}{SDDRidMIX}(object, ...)
}
\arguments{
\item{object}{an object of class \code{SDDRidMIX} obtained using the
\code{\link{verify_identification.PosteriorBSVARMIX}} function.}

\item{...}{additional arguments affecting the summary produced.}
}
\value{
A table reporting the logarithm of Bayes factors of normal to
non-normal shocks posterior odds \code{"log(SDDR)"} for each structural shock, 
their numerical standard errors \code{"NSE"}, and the implied posterior 
probability of the normality and non-normality hypothesis, 
\code{"Pr[normal|data]"} and \code{"Pr[non-normal|data]"} 
respectively.
}
\description{
Provides summary of the Savage-Dickey density ratios
for verification of structural shocks normality. The outcomes can be
used to make probabilistic statements about identification through 
non-normality.
}
\examples{
# upload data
data(us_fiscal_lsuw)

# specify the model and set seed
specification  = specify_bsvar_mix$new(us_fiscal_lsuw, M = 2)
set.seed(123)

# estimate the model
posterior      = estimate(specification, 10)

# verify heteroskedasticity
sddr           = verify_identification(posterior)
summary(sddr)

# workflow with the pipe |>
############################################################
set.seed(123)
us_fiscal_lsuw |>
  specify_bsvar_mix$new(M = 2) |>
  estimate(S = 10) |> 
  verify_identification() |> 
  summary() -> sddr_summary

}
\seealso{
\code{\link{verify_identification.PosteriorBSVARMIX}}
}
\author{
Tomasz Woźniak \email{wozniak.tom@pm.me}
}
