% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildmer-S4.R
\name{diag,formula-method}
\alias{diag,formula-method}
\title{Diagonalize the random-effect covariance structure, possibly assisting convergence}
\usage{
\S4method{diag}{formula}(x)
}
\arguments{
\item{x}{A model formula.}
}
\value{
The formula with all random-effect correlations forced to zero, per Pinheiro & Bates (2000)
}
\description{
Diagonalize the random-effect covariance structure, possibly assisting convergence
}
\examples{
# 1. Create explicit columns for factor variables
library(buildmer)
vowels <- cbind(vowels,model.matrix(~vowel,vowels))
# 2. Create formula with diagonal covariance structure
form <- diag(f1 ~ (vowel1+vowel2+vowel3+vowel4)*timepoint*following + 
	     ((vowel1+vowel2+vowel3+vowel4)*timepoint*following | participant) +
	     (timepoint | word))
# 3. Convert formula to buildmer terms list, grouping terms starting with 'vowel'
terms <- tabulate.formula(form,group='vowel[^:]')
# 4. Directly pass the terms object to buildmer(), using the 'dep' argument to specify the
# dependent variable
\donttest{model <- buildmer(terms,data=vowels,buildmerControl=list(dep='f1'))}
}
