% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess_miRTarBase.R
\name{preprocess_miRTarBase}
\alias{preprocess_miRTarBase}
\title{Creates a comparison table for miRTarBase to be used for custom integration}
\usage{
preprocess_miRTarBase(
  download.dir = ".",
  download.method = "auto",
  mirtarbase.file = NULL,
  organism.code,
  org.db,
  support.type = c(),
  validation.method = c(),
  reference = c("mRNA", "miRNA"),
  print.support.types = FALSE,
  print.validation.methods = FALSE
)
}
\arguments{
\item{download.dir}{Directory where miRTarBase database will be downloaded.}

\item{download.method}{Method for downloading miRTarBase file through download.file,
see download.file documentation for options for your operating system.}

\item{mirtarbase.file}{Path to pre-downloaded miRTarBase file for your organism.
If this is left NULL then the file will be downloaded.}

\item{organism.code}{Three letter code for the organism of choice. See miRTarBase
website for options. For human, enter 'hsa' and for mouse, 'mmu'.}

\item{org.db}{database for annotations to transform ENSEMBL IDs to
gene names; a list of bioconductor packaged databases can be found with
\code{BiocManager::available("^org\\.")}.}

\item{support.type}{Subset of entries of the 'Support Type' field in miRTarBase.
Only these values will be kept. To find the options available for your organism
of choice, run the function once with \code{print.support.types = TRUE}.}

\item{validation.method}{Subset of entries of 'Experiments' field in miRTarBase.
Only these values will be kept. To find the options available for your organism
of choice, run the function once with \code{print.validation.methods = TRUE}.}

\item{reference}{Should the reference category be mRNA or miRNA? The reference
category chosen here must match the reference category chosen in
\code{custom.integration} in \code{\link{generateShinyApp}}. Default in mRNA.}

\item{print.support.types, print.validation.methods}{Should options for
Support Type and Experiments be displayed? Default is FALSE.}
}
\value{
A dataframe with Reference_ID/Name and Comparison_ID/Name columns
which can be supplied to \code{custom.integration} in \code{\link{generateShinyApp}}
}
\description{
This function downloads the miRTarBase database for the organism
of choice, filters it according to user-specified values and formats ready for
custom integration in \code{\link{generateShinyApp}}.
}
\examples{
comparison.table <- preprocess_miRTarBase(
  mirtarbase.file = system.file("extdata", "mmu_MTI_sub.xls", package = "bulkAnalyseR"),
  organism.code = "mmu",
  org.db = "org.Mm.eg.db",
  support.type = "Functional MTI",
  validation.method = "Luciferase reporter assay",
  reference = "miRNA")
}
