% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspect_na.R
\name{inspect_na}
\alias{inspect_na}
\title{Summarize missingness in data frame columns}
\usage{
inspect_na(df)
}
\arguments{
\item{df}{A data frame}
}
\value{
A tibble summarizing the count and percentage of columnwise missingness for a data frame.
}
\description{
\code{inspect_na()} summarizes the rate of missingness in each column of a data frame. For a grouped data frame, the rate of missingness is summarized separately for each group.
}
\details{
The tibble returned contains the columns:
\itemize{
\item \strong{col_name}, a character vector containing column names of df1.
\item \strong{cnt}, an integer vector containing the number of missing values by column.
\item \strong{pcnt}, the percentage of records in each columns that is missing.
}
}
\examples{

library(dplyr)

# dataframe summary

inspect_na(airquality)

# grouped dataframe summary

airquality \%>\%
group_by(Month) \%>\%
 inspect_na()

}
