% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pair_methods.R
\name{pair_nmi}
\alias{pair_nmi}
\title{Normalized mutual information}
\usage{
pair_nmi(d, handle.na = TRUE, warnings = TRUE, ...)
}
\arguments{
\item{d}{A dataframe}

\item{handle.na}{If TRUE uses pairwise complete observations to calculate normalized mutual information, otherwise NAs not handled.}

\item{warnings}{If TRUE, generates a warning for datasets of one row, one column, or with constant variables.}

\item{...}{other arguments}
}
\value{
A tibble of class \code{pairwise}
}
\description{
Calculates normalized mutual information for every numeric or factor or mixed variable pair in a dataset.
}
\details{
The normalized mutual information is calculated using \code{\link[linkspotter]{maxNMI}} from linkpotter package
}
\examples{
if (requireNamespace("linkspotter", quietly = TRUE)) { 
   pair_nmi(iris)
}
}
