% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_ladestationen.R
\name{ladestationen_query}
\alias{ladestationen_query}
\title{Query charging stations}
\usage{
ladestationen_query(
  params = list(),
  safe = TRUE,
  refresh = FALSE,
  flatten = FALSE,
  flatten_mode = "json"
)
}
\arguments{
\item{params}{Query parameters for the ArcGIS service.}

\item{safe}{Logical; apply throttling and caching.}

\item{refresh}{Logical; refresh cached responses.}

\item{flatten}{Logical; drop nested list columns.}

\item{flatten_mode}{Flatten strategy for list columns. Use "unnest" to
expand list-columns into multiple rows.}
}
\value{
A tibble with charging station records.
}
\description{
Query charging stations
}
\details{
The Ladesaeulenregister API is backed by an ArcGIS feature service. You must
supply a \code{geometry} filter and \code{outFields}. The ArcGIS service may require a
\code{token} query parameter even though the API docs describe the service as
public. Official docs:
https://ladestationen.api.bund.dev.
}
\examples{
\dontrun{
geometry <- jsonlite::toJSON(
  list(
    xmin = 13.3, ymin = 52.4, xmax = 13.5, ymax = 52.6,
    spatialReference = list(wkid = 4326)
  ),
  auto_unbox = TRUE
)
ladestationen_query(params = list(
  geometry = geometry,
  geometryType = "esriGeometryEnvelope",
  where = "1=1",
  outFields = "*",
  outSR = 4326,
  f = "json",
  returnGeometry = "false",
  resultRecordCount = 5
))
}

}
\seealso{
\code{\link[=bunddev_parameters]{bunddev_parameters()}} to inspect available query parameters.
}
