% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eventlog.R
\name{eventlog}
\alias{eventlog}
\title{Eventlog}
\usage{
eventlog(eventlog, case_id = NULL, activity_id = NULL,
  activity_instance_id = NULL, lifecycle_id = NULL, timestamp = NULL,
  resource_id = NULL)
}
\arguments{
\item{eventlog}{The data object to be used as event log. This can be a
\code{data.frame} or \code{tbl_df}.}

\item{case_id}{The case classifier of the event log.}

\item{activity_id}{The activity classifier of the event log.}

\item{activity_instance_id}{The activity instance classifier of the event log.}

\item{lifecycle_id}{The life cycle classifier of the event log.}

\item{timestamp}{The timestamp of the event log.}

\item{resource_id}{The resource identifier of the event log.}
}
\description{
A function to instantiate an object of class \code{eventlog} by specifying a
\code{data.frame} or \code{tbl_df} and appropriate case, activity and
timestamp classifiers.
}
\examples{
data <- data.frame(case = rep("A",5),
activity_id = c("A","B","C","D","E"),
activity_instance_id = 1:5,
lifecycle_id = rep("complete",5),
timestamp = 1:5,
resource = rep("resource 1", 5))
eventlog(data,case_id = "case",
activity_id = "activity_id",
activity_instance_id = "activity_instance_id",
lifecycle_id = "lifecycle_id",
timestamp = "timestamp",
resource_id = "resource")

}
\seealso{
\code{\link{case_id}}, \code{\link{activity_id}},
\code{\link{activity_instance_id}},\code{\link{lifecycle_id}},
 \code{\link{timestamp}}
}

