% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{count_event_position}
\alias{count_event_position}
\title{Count different events in an \code{fhx} object}
\usage{
count_event_position(x, injury_event = FALSE, position, groupby)
}
\arguments{
\item{x}{An \code{fhx} object.}

\item{injury_event}{Optional boolean indicating whether injuries should be
considered an "event". Default is \code{FALSE}.}

\item{position}{Optional character vector giving the types of event positions
to include in the count. Can be any combination of the following:
\itemize{
\item "unknown"
\item "dormant"
\item "early"
\item "middle"
\item "late"
\item "latewd"
}

The default counts all types of event positions.}

\item{groupby}{Optional named list containing character vectors that are used
to count the total number of different event types. The names given to each
character vector give the group's name in the output data frame.}
}
\value{
A data frame with a columns giving the event or event group and
values giving the corresponding count for each event type or group.
}
\description{
Count different events in an \code{fhx} object
}
\examples{
data(pgm)
count_event_position(pgm)

# As above, but considering injuries to be a type of event.
count_event_position(pgm, injury_event = TRUE)

# Count only events of a certain position, in this case, "unknown", "early",
# and "middle".
count_event_position(pgm,
  injury_event = TRUE,
  position = c("unknown", "early", "middle")
)

# Using custom "groupby" args.
grplist <- list(
  foo = c("dormant_fs", "early_fs"),
  bar = c("middle_fs", "late_fs")
)
count_event_position(pgm, groupby = grplist)

}
\seealso{
\itemize{
\item \code{\link[=get_event_years]{get_event_years()}} gets years for various events in an \code{fhx} object.
\item \code{\link[=yearly_recording]{yearly_recording()}} count the number of "recording" events in each year of
an \code{fhx} object.
\item \code{\link[=series_stats]{series_stats()}} basic summary stats for an \code{fhx} object.
}
}
