% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{gg_loss}
\alias{gg_loss}
\title{Compare Lists of Models}
\usage{
gg_loss(
  mod_list,
  y,
  type = c("mse", "mae", "mape", "mase"),
  mean_line = FALSE,
  line_param = list(),
  mean_param = list(),
  viridis = FALSE,
  viridis_option = "D",
  NROW = NULL,
  NCOL = NULL,
  ...
)
}
\arguments{
\item{mod_list}{Lists of forecast results (\code{predbvhar} objects)}

\item{y}{Test data to be compared. should be the same format with the train data and predict$forecast.}

\item{type}{Loss function to be used (\code{mse}: MSE, \code{mae}: MAE, \code{mape}: MAPE, \code{mase}: MASE)}

\item{mean_line}{Whether to draw average loss. By default, \code{FALSE}.}

\item{line_param}{Parameter lists for \code{\link[ggplot2:geom_path]{ggplot2::geom_path()}}.}

\item{mean_param}{Parameter lists for average loss with \code{\link[ggplot2:geom_abline]{ggplot2::geom_hline()}}.}

\item{viridis}{If \code{TRUE}, scale CI and forecast line using \code{\link[ggplot2:scale_viridis]{ggplot2::scale_fill_viridis_d()}} and \link[ggplot2:scale_viridis]{ggplot2::scale_colour_viridis_d}, respectively.}

\item{viridis_option}{Option for viridis string. See \code{option} of \link[ggplot2:scale_viridis]{ggplot2::scale_colour_viridis_d}. Choose one of \code{c("A", "B", "C", "D", "E")}. By default, \code{D}.}

\item{NROW}{\code{nrow} of \code{\link[ggplot2:facet_wrap]{ggplot2::facet_wrap()}}}

\item{NCOL}{\code{ncol} of \code{\link[ggplot2:facet_wrap]{ggplot2::facet_wrap()}}}

\item{...}{Additional options for \code{geom_loss} (\code{inherit.aes} and \code{show.legend})}
}
\value{
A ggplot object
}
\description{
Draw plot of test error for given models
}
\seealso{
\itemize{
\item \code{\link[=mse]{mse()}} to compute MSE for given forecast result
\item \code{\link[=mae]{mae()}} to compute MAE for given forecast result
\item \code{\link[=mape]{mape()}} to compute MAPE for given forecast result
\item \code{\link[=mase]{mase()}} to compute MASE for given forecast result
}
}
