% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zoom.R
\name{zoom}
\alias{zoom}
\alias{zoom.c3}
\title{Add C3 Zoom}
\usage{
zoom(c3, enabled = TRUE, rescale = NULL, extent = NULL, onzoom = NULL,
  onzoomstart = NULL, onzoomend = NULL, ...)

\method{zoom}{c3}(c3, enabled = TRUE, rescale = NULL, extent = NULL,
  onzoom = NULL, onzoomstart = NULL, onzoomend = NULL, ...)
}
\arguments{
\item{c3}{c3 htmlwidget object}

\item{enabled}{boolean default is TRUE}

\item{rescale}{boolean rescale axis when zooming}

\item{extent}{numeric vector}

\item{onzoom}{character js function, wrap character or character vector in JS()}

\item{onzoomstart}{character js function, wrap character or character vector in JS()}

\item{onzoomend}{character js function, wrap character or character vector in JS()}

\item{...}{additional options passed to the zoom object}
}
\value{
c3
}
\description{
Enable chart Zoom.
}
\examples{
data.frame(a = abs(rnorm(20) * 10),
           b = abs(rnorm(20) * 10)) \%>\%
     c3() \%>\%
     zoom()

}
\seealso{
Other c3: \code{\link{RColorBrewer}}, \code{\link{c3}},
  \code{\link{grid}}, \code{\link{legend}},
  \code{\link{region}}, \code{\link{subchart}},
  \code{\link{tooltip}}, \code{\link{xAxis}}
}
