% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelling.R
\name{checkConsistency}
\alias{checkConsistency}
\title{Check the consistency of the norm data model}
\usage{
checkConsistency(model, minAge = NULL, maxAge = NULL, minNorm = NULL,
  maxNorm = NULL, minRaw = NULL, maxRaw = NULL, stepAge = 1,
  stepNorm = 1, warn = FALSE, silent = FALSE, covariate = NULL)
}
\arguments{
\item{model}{The model from the bestModel function}

\item{minAge}{Age to start with checking}

\item{maxAge}{Upper end of the age check}

\item{minNorm}{Lower end of the norm value range}

\item{maxNorm}{Upper end of the norm value range}

\item{minRaw}{clipping parameter for the lower bound of raw scores}

\item{maxRaw}{clipping parameter for the upper bound of raw scores}

\item{stepAge}{Stepping parameter for the age check, usually 1 or 0.1; lower
values indicate higher precision / closer checks}

\item{stepNorm}{Stepping parameter for the norm table check within age with lower
scores indicating a higher precision. The choice depends of the norm scale
used. With T scores a stepping parameter of 1 is suitable}

\item{warn}{If set to TRUE, already minor violations of the model assumptions
are displayed (default = FALSE)}

\item{silent}{turn off messages}

\item{covariate}{In case, a covariate has been used, please specify the degree of the covariate /
the specific value here.}
}
\value{
Boolean, indicating model violations (TRUE) or no problems (FALSE)
}
\description{
While abilities increase and decline over age, within one age group, the
norm scores always have to show a linear increase with increasing raw
scores. Violations of this assumption are a strong indication for problems
in modeling the relationship between raw and norm scores. There are
several reasons, why this might occur:
\enumerate{
  \item Vertical extrapolation: Choosing extreme norm scores, e. g. values
  -3 <= x and x >= 3 In order to model these extreme values, a large sample
  dataset is necessary.
  \item Horizontal extrapolation: Taylor polynomials converge in a certain
  radius. Using the model values outside the original dataset may
  lead to inconsistent results.
  \item The data cannot be modeled with Taylor polynomials, or you need
  another power parameter (k) or R2 for the model.
 }
 In general, extrapolation (point 1 and 2) can carefully be done to a
 certain degree outside the original sample, but it should in general
 be handled with caution.
}
\examples{
normData <- prepareData()
m <- bestModel(normData)
modelViolations <- checkConsistency(m,
  minAge = 2, maxAge = 5, stepAge = 0.1,
  minNorm = 25, maxNorm = 75, minRaw = 0, maxRaw = 28, stepNorm = 1
)
plotDerivative(m, , minAge = 2, maxAge = 5, minNorm = 25, maxNorm = 75)
}
