% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ppvt}
\alias{ppvt}
\title{Vocabulary development from 2.5 to 17}
\format{
A data frame with 4542 rows and 6 variables:
\describe{
  \item{age}{the chronological age of the child}
  \item{sex}{the sex of the test taker, 1=male, 2=female}
  \item{migration}{migration status of the family, 0=no, 1=yes}
  \item{region}{factor specifiying the region, the data were collected; grouped into south, north, east and west}
  \item{raw}{the raw score of the student, spanning values from 0 to 228}
  \item{group}{age group of the child, determined by the getGroups()-function with 12 equidistant age groups}
}

A data frame with 5600 rows and 9 columns
}
\source{
\url{https://www.psychometrica.de/ppvt4.html}
}
\usage{
ppvt
}
\description{
A dataset based on an unstratified sample of PPVT4 data (German adaption). The PPVT4 consists of blocks of items with
12 items each. Each item consists of 4 pictures. The test taker is given a word orally and he or she has to point out
the picture matching the oral word. Bottom and ceiling blocks of items are determined according to age and performance. For
instance, when a student knows less than 4 word from a block of 12 items, the testing stops. The sample is not identical
with the norm sample and includes doublets of cases in order to align the sample size per age group. It is
primarily intended for running the cNORM analyses with regard to modeling and stratification.
}
\examples{
\dontrun{
# Example with continuous age variable, ranked with sliding window
model.ppvt.sliding <- cnorm(age=ppvt$age, raw=ppvt$raw, width=1)

# Example with age groups; you might first want to experiment with
# the granularity of the groups via the 'getGroups()' function
model.ppvt.group <- cnorm(group=ppvt$group, raw=ppvt$raw) # with predefined groups
model.ppvt.group <- cnorm(group=getGroups(ppvt$age, n=15, equidistant = T),
                          raw=ppvt$raw) # groups built 'on the fly'


# plot information function
plot(model.ppvt.group, "subset")

# check model consistency
checkConsistency(model.ppvt.group)

# plot percentiles
plot(model.ppvt.group, "percentiles")
}
}
\references{
Lenhard, A., Lenhard, W., Segerer, R. & Suggate, S. (2015). Peabody Picture Vocabulary Test - Revision IV (Deutsche Adaption). Frankfurt a. M./Germany: Pearson Assessment.
}
\concept{vocabulary acquisition development receptive}
\keyword{datasets}
