% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{cor_hist}
\alias{cor_hist}
\title{A histogram of the correlations of microRNA or tf sets}
\usage{
cor_hist(ob, study = NULL, ...)
}
\arguments{
\item{ob}{A \link{cmicroRNA} or \link{cTF} object such as this returned by
calling \link{cmicroRNA} or \link{cTF}.}

\item{study}{A \code{character} vector of The Cancer Genome Atlas (TCGA)
study identifiers. To view the available studies in TCGA project,
\url{https://tcga-data.nci.nih.gov/docs/publications/tcga}. When left to
default \code{NULL} all available studies will be included.}

\item{...}{Other options}
}
\value{
An \code{\link[graphics]{hist}} plot of the correlations values 
between genes a microRNA or a transcription factor in a TCGA study
}
\description{
Plot a \code{\link[graphics]{hist}} of sets of microRNAs or transcription
factors-gene correlations in a TCGA study.
}
\examples{
# load required libraries
library(RSQLite)
library(cRegulome)

# locate the testset file and connect
fl <- system.file('extdata', 'cRegulome.db', package = 'cRegulome')
conn <- dbConnect(SQLite(), fl)

# enter a custom query with different arguments
dat <- get_mir(conn,
               mir = c('hsa-let-7g', 'hsa-let-7i'),
               study = 'STES')

# make a cmicroRNA object   
cmir <- cmicroRNA(dat)

# print object
cor_hist(cmir)

}
