% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postestimate_test_MICOM.R
\name{testMICOM}
\alias{testMICOM}
\title{Test measurement invariance of composites}
\usage{
testMICOM(
 .object               = NULL,
 .alpha                = 0.05,
 .approach_p_adjust    = "none",
 .handle_inadmissibles = c("drop", "ignore", "replace"), 
 .R                    = 499,
 .seed                 = NULL,
 .verbose              = TRUE
 )
}
\arguments{
\item{.object}{An R object of class \link{cSEMResults} resulting from a call to \code{\link[=csem]{csem()}}.}

\item{.alpha}{An integer or a numeric vector of significance levels.
Defaults to \code{0.05}.}

\item{.approach_p_adjust}{Character string or a vector of character strings.
Approach used to adjust the p-value for multiple testing.
See the \code{methods} argument of \code{\link[stats:p.adjust]{stats::p.adjust()}} for a list of choices and
their description. Defaults to "\emph{none}".}

\item{.handle_inadmissibles}{Character string. How should inadmissible results
be treated? One of "\emph{drop}", "\emph{ignore}", or "\emph{replace}". If "\emph{drop}", all
replications/resamples yielding an inadmissible result will be dropped
(i.e. the number of results returned will potentially be less than \code{.R}).
For "\emph{ignore}" all results are returned even if all or some of the replications
yielded inadmissible results (i.e. number of results returned is equal to \code{.R}).
For "\emph{replace}" resampling continues until there are exactly \code{.R} admissible solutions.
Depending on the frequency of inadmissible solutions this may significantly increase
computing time. Defaults to "\emph{drop}".}

\item{.R}{Integer. The number of bootstrap replications. Defaults to \code{499}.}

\item{.seed}{Integer or \code{NULL}. The random seed to use. Defaults to \code{NULL} in which
case an arbitrary seed is chosen. Note that the scope of the seed is limited
to the body of the function it is used in. Hence, the global seed will
not be altered!}

\item{.verbose}{Logical. Should information (e.g., progress bar) be printed
to the console? Defaults to \code{TRUE}.}
}
\value{
A named list of class \code{cSEMTestMICOM} containing the following list element:
\describe{
\item{\verb{$Step2}}{A list containing the results of the test for compositional invariance (Step 2).}
\item{\verb{$Step3}}{A list containing the results of the test for mean and variance equality (Step 3).}
\item{\verb{$Information}}{A list of additional information on the test.}
}
}
\description{
This functions performs the test for measurement invariance of composites
proposed by \insertCite{Henseler2016;textual}{cSEM}.
}
\details{
The test is only meaningful for concepts modeled as composites.

If more than two groups are to be compared issues related to multiple testing
should be taken into account.

Models containing second-order constructs are not supported yet.

The number of permutation runs defaults to \code{args_default()$.R} for performance reasons.
According to \insertCite{Henseler2016;textual}{cSEM} the number of permutations should
be at least 5000 for assessment to be sufficiently reliable.
}
\examples{
\dontrun{
# NOTE: to run the example. Download and load the newst version of cSEM.DGP
# from GitHub using devtools::install_github("M-E-Rademaker/cSEM.DGP").

# Create two data generating processes (DGPs) that only differ in how the composite
# X is build. Hence, the two groups are not compositionally invariant.
dgp1 <- "
# Structural model
Y ~ 0.6*X

# Measurement model
Y =~ 1*y1
X <~ 0.4*x1 + 0.8*x2

x1 ~~ 0.3125*x2
"

dgp2 <- "
# Structural model
Y ~ 0.6*X

# Measurement model
Y =~ 1*y1
X <~ 0.8*x1 + 0.4*x2

x1 ~~ 0.3125*x2
"

g1 <- generateData(dgp1, .N = 399, .empirical = TRUE) # requires cSEM.DGP 
g2 <- generateData(dgp2, .N = 200, .empirical = TRUE) # requires cSEM.DGP

# Model is the same for both DGPs
model <- "
# Structural model
Y ~ X

# Measurement model
Y =~ y1
X <~ x1 + x2
"

# Estimate
csem_results <- csem(.data = list("group1" = g1, "group2" = g2), model)

# Test
testMICOM(csem_results, .R = 50, .alpha = c(0.01, 0.05), .seed = 1987)
}
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=csem]{csem()}}, \link{cSEMResults}, \code{\link[=testOMF]{testOMF()}}, \code{\link[=testMGD]{testMGD()}}
}
