% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_assess.R
\name{calculateFLCriterion}
\alias{calculateFLCriterion}
\title{Fornell-Larcker criterion}
\usage{
calculateFLCriterion(
  .object              = NULL,
  .only_common_factors = TRUE,
  ...
  )
}
\arguments{
\item{.object}{An R object of class \link{cSEMResults} resulting from a call to \code{\link[=csem]{csem()}}.}

\item{.only_common_factors}{Logical. Should only concepts modeled as common
factors be included when calculating one of the following quality criteria:
AVE, the Fornell-Larcker criterion, HTMT, and all reliability estimates.
Defaults to \code{TRUE}.}

\item{...}{Ignored.}
}
\value{
A matrix with the squared construct correlations on the off-diagonal and
the AVE's on the main diagonal.
}
\description{
Computes the Fornell-Larcker matrix.
}
\details{
The Fornell-Larcker criterion (FL criterion) is a rule suggested by \insertCite{Fornell1981;textual}{cSEM}
to assess discriminant validity. The Fornell-Larcker
criterion is a decision rule based on a comparison between the squared
construct correlations and the average variance extracted (AVE).

The FL criterion is inherently tied to the common factor model. It is therefore
unclear how to meaningfully interpret the FL criterion in the context of a
model that contains constructs modeled as composites.
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=assess]{assess()}}, \link{cSEMResults}
}
