% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{cache}
\alias{cache}
\title{Cache or Retrieve Computation Results}
\usage{
cache(..., .cachedir = here(".cache-R"), .rerun = FALSE)
}
\arguments{
\item{...}{Named expressions to be cached or retrieved.}

\item{.cachedir}{Directory where cache files are stored. Default is a directory called \code{.cache-R} located at the project root.}

\item{.rerun}{Whether or not to clear the cache and re-run the provided expressions. Defaults to FALSE.}
}
\description{
Cache or retrieve an evaluated expression. Results are always made available in the current environment.
}
\examples{
tmp <- tempdir()

# Takes 1 second to execute
cache(a = {
  Sys.sleep(1)
  "Hello World"
}, .cachedir = tmp)

# Executes instantly
cache(a = {
  Sys.sleep(1)
  "Hello World"
}, .cachedir = tmp)

# Result is available in the current environment
print(a)

# Re-run the expression
cache(a = {
  Sys.sleep(1)
  "Hello World"
}, .cachedir = tmp, .rerun = TRUE)
}
