% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache-layered.R
\name{cache_layered}
\alias{cache_layered}
\title{Compose any number of cache objects into a new, layered cache object}
\usage{
cache_layered(..., logfile = NULL)
}
\arguments{
\item{...}{Cache objects to compose into a new, layered cache object.}

\item{logfile}{An optional filename or connection object to where logging
information will be written. To log to the console, use \code{stderr()} or
\code{stdout()}.}
}
\value{
A layered caching object, with class \code{cache_layered}.
}
\description{
Note that \code{cache_layered} is currently experimental.
}
\examples{

# Make a layered cache from a small memory cache and large disk cache
m <- cache_mem(max_size = 100 * 1024^2)
d <- cache_disk(max_size = 2 * 1024^3)
cl <- cache_layered(m, d)
}
