% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calACSstrLoose.r
\name{calACSstrLoose}
\alias{calACSstrLoose}
\title{Calculate the total number of all common subsequences between 2 strings.
Subsequences can be interrupted by items, i.e. q-w is a common subsequence of q-w-e-r and q-e-w-r}
\usage{
calACSstrLoose(strA, strB, sep = "-", dropFirstItem = FALSE)
}
\arguments{
\item{strA}{First string}

\item{strB}{Second string}

\item{sep}{Delimiter separating each items in a sequence}

\item{dropFirstItem}{Boolean. If true, the first item in each sequence is excluded from counting all subsequences}
}
\value{
The total number of all common subsequences as an integer
}
\description{
Calculate the total number of all common subsequences between 2 strings.
Subsequences can be interrupted by items, i.e. q-w is a common subsequence of q-w-e-r and q-e-w-r
}
\examples{
calACSstrLoose("q-w-e-r", "q-e-w-r", "-")
calACSstrLoose("itemToBeDropped-q-w-e-r", "itemToBeDroped-q-e-w-r", "-", dropFirstItem=TRUE)

}

