% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{diag}
\alias{diag}
\alias{diag<-}
\title{Tensor Diagonals}
\usage{
diag(x, dim = 2, value = 1)

diag(x) <- value
}
\arguments{
\item{x}{array, vector or integer.}

\item{dim}{the dimension of the tensor.}

\item{value}{the value for the diagonal elements.}
}
\value{
array diagonals.
}
\description{
Extracts or replace the diagonal of a tensor, or construct a diagonal tensor.
}
\section{Functions}{
\itemize{
\item \code{diag}: get diagonals.

\item \code{diag<-}: set diagonals.
}}

\examples{
# construct a diagonal 2x2 matrix
diag(2)

# construct a diagonal 2x2x2 tensor
diag(2, dim = 3)

# construct a diagonal 2x2x2 tensor with values 3 and 4
diag(2, dim = 3, value = c(3,4))
  
# construct a diagonal 3x3 matrix with values 1,2,3
diag(1:3) 
  
# extract diagonals 
x <- diag(1:4, dim = 3)
diag(x)

# replace diagonals
x <- diag(1:4, dim = 3)
diag(x) <- c(5,6,7,8)
x

}
