% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_comp.R
\name{stat_comp}
\alias{stat_comp}
\title{Comparison statistics on matched data}
\usage{
stat_comp(x)
}
\arguments{
\item{x}{A \code{callback} object.}
}
\value{
A \code{stat_comp} objects including two data frames. The first data frame is \code{Student} and includes the following variables:
\tabular{ll}{
\code{p_callback1-p_callback2} \tab callback rates difference\cr
\code{Student}\tab Student statistics for \code{dif(cand1-cand2)}\cr
\code{p_value}\tab p-value for \code{Student}\cr
}
The second data frame is \code{binom} and includes the following variables:
\tabular{ll}{
\code{r_cand1}\tab proportion of callbacks received by the 1st candidate\cr
\code{r_dif}\tab \code{r_cand-0.5}\cr
\code{r_pvalue}\tab p-value of the binomial test \code{r_cand1=0.5} \cr
}
}
\description{
Comparison statistics on matched data
}
\examples{
data(labour1)
x <- callback(data=labour1,cluster="offer",candid="hist",callback="callback")
stat_comp(x)
}
