% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsa_functions.R
\name{rsa}
\alias{rsa}
\title{Perform representational similarity analysis}
\usage{
rsa(x, comparisons, test = FALSE, ...)
}
\arguments{
\item{x}{A list of \linkS4class{CalmrExperiment} objects}

\item{comparisons}{A model-named list containing the model
outputs to compare.}

\item{test}{Whether to test the RSA via permutation test. Default = FALSE.}

\item{...}{Additional parameters passed to \code{stats::dist()}
and \code{stats::cor()}}
}
\value{
A CalmrRSA object
}
\description{
Perform representational similarity analysis
}
\note{
The object returned by this function
can be later tested via its own \code{\link[=test]{test()}} method.
}
\examples{
# Comparing the associations in three models
exp <- data.frame(
  Group = c("A", "B"),
  P1 = c("2(A)>(US)/1B>(US)", "1(A)>(US)/2B>(US)"),
  R1 = TRUE
)
models <- c("HD2022", "RW1972", "PKH1982")
parameters <- sapply(models, get_parameters, design = exp)
exp_res <- compare_models(exp,
  models = models
)
comparisons <- list(
  "HD2022" = c("vs"),
  "RW1972" = c("vs"),
  "PKH1982" = c("eivs")
)
res <- rsa(exp_res, comparisons = comparisons)
test(res, n_samples = 20)
}
