% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/communityModel.R
\name{fit,commOccu-method}
\alias{fit,commOccu-method}
\title{Fit a community (multi-species) occupancy model}
\usage{
\S4method{fit}{commOccu}(
  object,
  n.iter = 100,
  thin = 1,
  n.burnin = n.iter/2,
  n.adapt = 0,
  chains = 3,
  inits = NULL,
  compile = TRUE,
  WAIC = FALSE,
  quiet = FALSE,
  ...
)
}
\arguments{
\item{object}{\code{commOccu} object}

\item{n.iter}{number of iterations to monitor}

\item{thin}{thinning interval for monitors}

\item{n.burnin}{burnin length. Defaults to half of n.iter.}

\item{n.adapt}{Length of adaptive phase}

\item{chains}{number of MCMC chains to run}

\item{inits}{named list. Initial values to use. If NULL (default), the values from the inits function in \code{object} are used.}

\item{compile}{logical. If Nimble model, compile model with \code{\link[nimble]{compileNimble}} before running model?}

\item{WAIC}{logical. Return WAIC (only Nimble models)}

\item{quiet}{if TRUE messages and progress bar will be suppressed}

\item{...}{additional arguments to pass to \code{\link[nimble]{runMCMC}} (only relevant for Nimble)}
}
\value{
A coda::mcmc.list
}
\description{
Convenience function for fitting community occupancy models (defined in a commOccu object) in JAGS or Nimble.
}
\details{
Models will be fit either in JAGS or Nimble, depending on the decision made in the \code{nimble} argument in \code{\link{communityModel}}.

For Nimble, compilation is strongly recommended for long model runs. Uncompiled models can run extremely slow. Compilation itself can take a while also, and requires that Rtools is available on the system.

This is a convenience function only which hides some of the configuration options. If you require more control over model fitting, you can run all steps individually. See vignette 5 for details.
}
