% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_coef,commOccu-method}
\alias{plot_coef,commOccu-method}
\alias{plot_coef}
\title{Plot effect sizes of covariates in community occupancy model}
\usage{
\S4method{plot_coef}{commOccu}(
  object,
  mcmc.list,
  submodel = "state",
  ordered = TRUE,
  combine = FALSE,
  outdir,
  level = c(outer = 0.95, inner = 0.75),
  colorby = "significance",
  scales = "free_y",
  community_lines = FALSE,
  ...
)
}
\arguments{
\item{object}{\code{commOccu} object}

\item{mcmc.list}{mcmc.list. Output of \code{fit} called on a \code{commOccu} object}

\item{submodel}{character. Submodel to get plots for. Can be \code{"det"} or \code{"state"}}

\item{ordered}{logical. Order species in plot by median effect (TRUE) or by species name (FALSE)}

\item{combine}{logical. Combine multiple plots into one plot (via facets)?}

\item{outdir}{character. Directory to save plots to (optional)}

\item{level}{numeric. Probability mass to include in the uncertainty interval (two values named "outer" and "inner", in that order). Second value (= inner interval) will be plotted thicker.}

\item{colorby}{character. Whether to color estimates by \code{"significance"} (of the effect estimates), or \code{"Bayesian p-value"} (of the species). Currently allows only \code{"significance"}.}

\item{scales}{character. Passed to \code{\link[ggplot2]{facet_grid}}. Can be \code{"free"} to scale x axes of effect estimates independently, or "free_y" to scale all x axes identically.}

\item{community_lines}{logical. Add faint vertical lines to the plot indicating median community effect (solid line) and its confidence interval (first value from \code{level}).}

\item{...}{additional arguments for \code{\link[ggplot2]{ggsave}} - only relevant if \code{outdir} is defined.}
}
\value{
A list of ggplot objects (one list item per covariate).
}
\description{
Plot effect sizes for all species in a community (multi-species) occupancy model. Currently only supports continuous covariates, not categorical covariates.
}
\details{
Users who wish to create their own visualizations can use the data stored in the ggplot output. It is accessed via e.g. \code{output$covariate_name$data}
}
