% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpr_classify_endem.R
\name{cpr_classify_endem}
\alias{cpr_classify_endem}
\title{Classify phylogenetic endemism}
\usage{
cpr_classify_endem(df)
}
\arguments{
\item{df}{Input data frame. Must have the following columns:
\itemize{
\item \code{pe_obs_p_upper}: Upper \emph{p}-value comparing observed phylogenetic endemism
to random values
\item \code{pe_alt_obs_p_upper}: Upper \emph{p}-value comparing observed phylogenetic
endemism on alternate tree to random values
\item \code{rpe_obs_p_upper}: Upper \emph{p}-value comparing observed relative phylogenetic
endemism to random values
}}
}
\value{
Object of class data.frame with column \code{endem_type} (character)
added. Values of \code{endem_type} type include \code{paleo} (paleoendemic), \code{neo}
(neoendemic), \verb{not significant} (what it says), \code{mixed} (mixed endemism),
and \code{super} (super-endemic; both \code{pe_obs} and \code{pe_obs_alt} are highly
significant).
}
\description{
Given the results of \code{\link[=cpr_rand_test]{cpr_rand_test()}}, classifies phylogenetic endemism
according to CANAPE scheme of Mishler et al. 2014.
}
\details{
For a summary of the classification scheme, see:
\url{http://biodiverse-analysis-software.blogspot.com/2014/11/canape-categorical-analysis-of-palaeo.html} # nolint
}
\examples{
\donttest{
set.seed(12345)
data(phylocom)
rand_test <- cpr_rand_test(
  phylocom$comm, phylocom$phy,
  null_model = "curveball", metrics = c("pe", "rpe"), n_reps = 10
)
cpr_classify_endem(rand_test)
}
}
\references{
Mishler, B., Knerr, N., González-Orozco, C. et al.  (2014)
Phylogenetic measures of biodiversity and neo- and paleo-endemism in
Australian Acacia. Nat Commun, 5: 4473. \doi{10.1038/ncomms5473}
}
