% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_cervical_positive.R
\name{get_cervical_positive}
\alias{get_cervical_positive}
\title{Retrieves Cervical Cancer Screening Data with Positive Results}
\usage{
get_cervical_positive(
  start_date,
  end_date = NULL,
  level = c("kenya", "county", "subcounty", "ward", "facility"),
  organisations = NULL,
  categories = NULL,
  elements = NULL,
  ...
)
}
\arguments{
\item{start_date}{The start date to retrieve data. It is required and in the format \code{YYYY-MM-dd}.}

\item{end_date}{The ending date for data retrieval (default is the current date).}

\item{level}{The desired data granularity: \code{"kenya"} (the default), \code{"county"}, \code{"subcounty"}, \code{"ward"}, or \code{"facility"}.}

\item{organisations}{A list of organization units in the data. If NULL, downloaded using \code{\link[=get_organisation_units_metadata]{get_organisation_units_metadata()}}.}

\item{categories}{A list of categories to include. If NULL, downloaded using \code{\link[=get_category_options_metadata]{get_category_options_metadata()}}.}

\item{elements}{A list of data elements to include. If NULL, downloaded using \code{\link[=get_data_elements_metadata]{get_data_elements_metadata()}}.}

\item{...}{Other options that can be passed onto KHIS API.}
}
\value{
A tibble containing cervical cancer screening data with positive results
with the following columns:
\itemize{
\item kenya      - Optional if the level is Kenya.
\item county     - Name of the county. Optional if the level is \code{county}, \code{subcounty}, \code{ward} or \code{facility}.
\item subcounty  - Name of the subcounty. Optional if the level is \code{subcounty}, \code{ward} or \code{facility}.
\item ward       - Name of the ward. Optional if the level is \code{ward} or \code{facility}.
\item facility   - Name of the health facility. Optional if the level \code{facility}.
\item period     - The month and year of the data.
\item fiscal_year- The financial year of the report(July-June Cycle).
\item year       - The calendar year of the report.
\item month      - The month name of the report.
\item category   - The age group category of the report (<25, 25-49, 50+).
\item category2  - Additional category if available.
\item element    - The data element (HPV, VIA or Pap Smear).
\item source     - The source report (MOH 711 or MOH 745).
\item value      - The number reported.
}
}
\description{
\code{get_cervical_positive()} retrieves cervical cancer screening data with positive results
for a specified period from the KHIS API server using \code{\link[=get_analytics]{get_analytics()}}.
}
\examples{
\dontshow{if (khis_has_cred()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Download data from February 2023 to current date
positive <- get_cervical_positive(start_date = '2023-02-01')
positive
\dontshow{\}) # examplesIf}
}
\seealso{
\itemize{
\item \code{\link[=get_analytics]{get_analytics()}} for retrieving data from KHIS
}
}
