% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Wilks.cancor.R
\name{Wilks}
\alias{Wilks}
\alias{Wilks.cancor}
\alias{Wilks.candisc}
\title{Wilks Lambda Tests for Canonical Correlations}
\usage{
Wilks(object, ...)

\method{Wilks}{cancor}(object, ...)

\method{Wilks}{candisc}(object, ...)
}
\arguments{
\item{object}{An object of class \verb{"cancor""} or \verb{"candisc""}}

\item{\dots}{Other arguments passed to methods (not used)}
}
\value{
A data.frame (of class \code{"anova"}) containing the test
statistics
}
\description{
Tests the sequential hypotheses that the \eqn{i}th canonical correlation and
all that follow it are zero, \deqn{\rho_i = \rho_{i+1} = \cdots = 0}
}
\details{
Wilks' Lambda values are calculated from the eigenvalues and converted to F
statistics using Rao's approximation.
}
\section{Methods (by class)}{
\itemize{
\item \code{Wilks(cancor)}: \code{"cancor"} method.

\item \code{Wilks(candisc)}: \code{print()} method for \code{"candisc"} objects.

}}
\examples{

data(Rohwer, package="heplots")
X <- as.matrix(Rohwer[,6:10])  # the PA tests
Y <- as.matrix(Rohwer[,3:5])   # the aptitude/ability variables

cc <- cancor(X, Y, set.names=c("PA", "Ability"))
Wilks(cc)

iris.mod <- lm(cbind(Petal.Length, Sepal.Length, Petal.Width, Sepal.Width) ~ Species, data=iris)
iris.can <- candisc(iris.mod, data=iris)
Wilks(iris.can)


}
\references{
Mardia, K. V., Kent, J. T. and Bibby, J. M. (1979).
\emph{Multivariate Analysis}. London: Academic Press.
}
\seealso{
\code{\link[=cancor]{cancor()}}
}
\author{
Michael Friendly
}
\keyword{htest}
