% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cansim_metadata.R
\name{add_cansim_vectors_to_template}
\alias{add_cansim_vectors_to_template}
\title{Retrieve series info for given table id and coordinates}
\usage{
add_cansim_vectors_to_template(template, refresh = FALSE)
}
\arguments{
\item{template}{A (possibly filtered) cansim table template as returned by `get_cansim_table_template`}

\item{refresh}{Refresh the data from the Statistics Canada API}
}
\value{
a tibble containing the table template with added vector information
}
\description{
Retrieves vector information for given table and coordinates. This can be used to query data by vectors, it only
returns vector information on coordinates which are present in the data table, so it gives an effective way to filter
coordinates. Vector information is not available for census data tables.
}
\examples{
\dontrun{
template <- get_cansim_table_template("34-10-0013")
template |> filter(Geography=="Canada") |>
  add_cansim_vectors_to_template()
}
}
